/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.datasources.PerUserPoolDataSource;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.datasource.DBPoolView;
import org.apache.synapse.commons.datasource.DataSourceFinder;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.DataSourceRepositoryHolder;
import org.apache.synapse.commons.datasource.DatasourceMBeanRepository;
import org.apache.synapse.commons.datasource.RepositoryBasedDataSourceFinder;
import org.apache.synapse.commons.datasource.factory.DataSourceFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.db.DBLookupMediator;
import org.apache.synapse.mediators.db.Statement;
import org.apache.synapse.securevault.secret.SecretManager;

public abstract class AbstractDBMediator
extends AbstractMediator
implements ManagedLifecycle {
    private DataSourceInformation dataSourceInformation;
    private String dataSourceName;
    private Properties jndiProperties = new Properties();
    private DataSource dataSource;
    private DBPoolView dbPoolView;
    private final List<Statement> statementList = new ArrayList<Statement>();
    private Map<Object, String> dataSourceProps = new HashMap<Object, String>();

    @Override
    public void init(SynapseEnvironment se) {
        if (this.dataSourceName != null) {
            this.dataSource = this.lookupDataSource(this.dataSourceName, this.jndiProperties);
        } else if (this.dataSourceInformation != null) {
            this.dataSource = this.createCustomDataSource(this.dataSourceInformation);
        }
    }

    @Override
    public void destroy() {
        if (this.dataSourceName != null) {
            return;
        }
        if (this.dataSource instanceof BasicDataSource) {
            try {
                ((BasicDataSource)this.dataSource).close();
                this.log.info((Object)("Successfully shut down DB connection pool for URL : " + this.getDSName()));
            }
            catch (SQLException e) {
                this.log.warn((Object)("Error shutting down DB connection pool for URL : " + this.getDSName()));
            }
        } else if (this.dataSource instanceof PerUserPoolDataSource) {
            ((PerUserPoolDataSource)this.dataSource).close();
            this.log.info((Object)("Successfully shut down DB connection pool for URL : " + this.getDSName()));
        }
    }

    @Override
    public boolean mediate(MessageContext synCtx) {
        String name = this instanceof DBLookupMediator ? "DBLookup" : "DBReport";
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : " + name + " mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        for (Statement aStatement : this.statementList) {
            if (aStatement == null) continue;
            this.processStatement(aStatement, synCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("End : " + name + " mediator");
        }
        return true;
    }

    protected abstract void processStatement(Statement var1, MessageContext var2);

    protected String getDSName() {
        if (this.dataSourceName != null) {
            return this.dataSourceName;
        }
        if (this.dataSourceInformation != null) {
            String name = this.dataSourceInformation.getUrl();
            if (name == null) {
                name = this.dataSourceInformation.getDatasourceName();
            }
            return name;
        }
        return null;
    }

    public void setDataSourceInformation(DataSourceInformation dataSourceInformation) {
        this.dataSourceInformation = dataSourceInformation;
    }

    public void setJndiProperties(Properties jndiProperties) {
        this.jndiProperties = jndiProperties;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void addDataSourceProperty(QName name, String value) {
        this.dataSourceProps.put(name, value);
    }

    public void addDataSourceProperty(String name, String value) {
        this.dataSourceProps.put(name, value);
    }

    public void addStatement(Statement stmnt) {
        this.statementList.add(stmnt);
    }

    public List<Statement> getStatementList() {
        return this.statementList;
    }

    public DBPoolView getDbPoolView() {
        return this.dbPoolView;
    }

    public void setDbPoolView(DBPoolView dbPoolView) {
        this.dbPoolView = dbPoolView;
    }

    protected PreparedStatement getPreparedStatement(Statement stmnt, Connection con, MessageContext msgCtx) throws SQLException {
        SynapseLog synLog = this.getLog(msgCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Getting a connection from DataSource " + this.getDSName() + " and preparing statement : " + stmnt.getRawStatement());
        }
        if (con == null) {
            String msg = "Connection from DataSource " + this.getDSName() + " is null.";
            this.log.error((Object)msg);
            throw new SynapseException(msg);
        }
        if (this.dataSource instanceof BasicDataSource) {
            BasicDataSource basicDataSource = (BasicDataSource)this.dataSource;
            int numActive = basicDataSource.getNumActive();
            int numIdle = basicDataSource.getNumIdle();
            String connectionId = Integer.toHexString(con.hashCode());
            DBPoolView dbPoolView = this.getDbPoolView();
            if (dbPoolView != null) {
                dbPoolView.setNumActive(numActive);
                dbPoolView.setNumIdle(numIdle);
                dbPoolView.updateConnectionUsage(connectionId);
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("[ DB Connection : " + con + " ]");
                synLog.traceOrDebug("[ DB Connection instance identifier : " + connectionId + " ]");
                synLog.traceOrDebug("[ Number of Active Connection : " + numActive + " ]");
                synLog.traceOrDebug("[ Number of Idle Connection : " + numIdle + " ]");
            }
        }
        PreparedStatement ps = con.prepareStatement(stmnt.getRawStatement());
        List<Statement.Parameter> params = stmnt.getParameters();
        int column = 1;
        block15: for (Statement.Parameter param : params) {
            String value;
            if (param == null) continue;
            String string = value = param.getPropertyName() != null ? param.getPropertyName() : param.getXpath().stringValueOf(msgCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting as parameter : " + column + " value : " + value + " as JDBC Type : " + param.getType() + "(see java.sql.Types for valid types)");
            }
            switch (param.getType()) {
                case -1: 
                case 1: 
                case 12: {
                    if (value != null && value.length() != 0) {
                        ps.setString(column++, value);
                        continue block15;
                    }
                    ps.setString(column++, null);
                    continue block15;
                }
                case 2: 
                case 3: {
                    if (value != null && value.length() != 0) {
                        ps.setBigDecimal(column++, new BigDecimal(value));
                        continue block15;
                    }
                    ps.setBigDecimal(column++, null);
                    continue block15;
                }
                case -7: {
                    if (value != null && value.length() != 0) {
                        ps.setBoolean(column++, Boolean.parseBoolean(value));
                        continue block15;
                    }
                    ps.setNull(column++, -7);
                    continue block15;
                }
                case -6: {
                    if (value != null && value.length() != 0) {
                        ps.setByte(column++, Byte.parseByte(value));
                        continue block15;
                    }
                    ps.setNull(column++, -6);
                    continue block15;
                }
                case 5: {
                    if (value != null && value.length() != 0) {
                        ps.setShort(column++, Short.parseShort(value));
                        continue block15;
                    }
                    ps.setNull(column++, 5);
                    continue block15;
                }
                case 4: {
                    if (value != null && value.length() != 0) {
                        ps.setInt(column++, Integer.parseInt(value));
                        continue block15;
                    }
                    ps.setNull(column++, 4);
                    continue block15;
                }
                case -5: {
                    if (value != null && value.length() != 0) {
                        ps.setLong(column++, Long.parseLong(value));
                        continue block15;
                    }
                    ps.setNull(column++, -5);
                    continue block15;
                }
                case 7: {
                    if (value != null && value.length() != 0) {
                        ps.setFloat(column++, Float.parseFloat(value));
                        continue block15;
                    }
                    ps.setNull(column++, 7);
                    continue block15;
                }
                case 6: {
                    if (value != null && value.length() != 0) {
                        ps.setDouble(column++, Double.parseDouble(value));
                        continue block15;
                    }
                    ps.setNull(column++, 6);
                    continue block15;
                }
                case 8: {
                    if (value != null && value.length() != 0) {
                        ps.setDouble(column++, Double.parseDouble(value));
                        continue block15;
                    }
                    ps.setNull(column++, 8);
                    continue block15;
                }
                case 91: {
                    if (value != null && value.length() != 0) {
                        ps.setDate(column++, Date.valueOf(value));
                        continue block15;
                    }
                    ps.setNull(column++, 91);
                    continue block15;
                }
                case 92: {
                    if (value != null && value.length() != 0) {
                        ps.setTime(column++, Time.valueOf(value));
                        continue block15;
                    }
                    ps.setNull(column++, 92);
                    continue block15;
                }
                case 93: {
                    if (value != null && value.length() != 0) {
                        ps.setTimestamp(column++, Timestamp.valueOf(value));
                        continue block15;
                    }
                    ps.setNull(column++, 93);
                    continue block15;
                }
            }
            String msg = "Trying to set an un-supported JDBC Type : " + param.getType() + " against column : " + column + " and statement : " + stmnt.getRawStatement() + " used by a DB mediator against DataSource : " + this.getDSName() + " (see java.sql.Types for valid type values)";
            this.handleException(msg, msgCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Successfully prepared statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName());
        }
        return ps;
    }

    private DataSource lookupDataSource(String dataSourceName, Properties jndiProperties) {
        DatasourceMBeanRepository mBeanRepository;
        Object mBean;
        DataSource dataSource = null;
        RepositoryBasedDataSourceFinder finder = DataSourceRepositoryHolder.getInstance().getRepositoryBasedDataSourceFinder();
        if (finder.isInitialized()) {
            dataSource = finder.find(dataSourceName);
        }
        if (dataSource == null) {
            String password = jndiProperties.getProperty("java.naming.security.credentials");
            if (password != null && !"".equals(password)) {
                jndiProperties.put("java.naming.security.credentials", this.getActualPassword(password));
            }
            if ((dataSource = DataSourceFinder.find((String)dataSourceName, (Properties)jndiProperties)) == null) {
                this.handleException("Cannot find a DataSource " + dataSourceName + " for given JNDI properties :" + jndiProperties);
            }
        }
        if ((mBean = (mBeanRepository = DatasourceMBeanRepository.getInstance()).getMBean(dataSourceName)) instanceof DBPoolView) {
            this.setDbPoolView((DBPoolView)mBean);
        }
        this.log.info((Object)("Successfully looked up datasource " + dataSourceName + "."));
        return dataSource;
    }

    protected DataSource createCustomDataSource(DataSourceInformation dataSourceInformation) {
        DataSource dataSource = DataSourceFactory.createDataSource((DataSourceInformation)dataSourceInformation);
        if (dataSource != null) {
            this.log.info((Object)("Successfully created data source for " + dataSourceInformation.getUrl() + "."));
        }
        return dataSource;
    }

    private String getActualPassword(String aliasPasword) {
        SecretManager secretManager = SecretManager.getInstance();
        if (secretManager.isInitialized()) {
            return secretManager.getSecret(aliasPasword);
        }
        return aliasPasword;
    }

    protected void handleException(String message) {
        LogFactory.getLog(this.getClass()).error((Object)message);
        throw new SynapseException(message);
    }

    public Map<Object, String> getDataSourceProps() {
        return this.dataSourceProps;
    }
}

