/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.MIMEAwareBuilder;
import org.apache.axis2.context.MessageContext;

public class SOAPBuilder
implements MIMEAwareBuilder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        try {
            String charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
            DetachableInputStream is = new DetachableInputStream(inputStream);
            messageContext.setProperty("org.apache.axiom.om.util.DetachableInputStream", is);
            SOAPModelBuilder builder = OMXMLBuilderFactory.createSOAPModelBuilder((InputStream)is, (String)charSetEncoding);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            BuilderUtil.validateSOAPVersion(BuilderUtil.getEnvelopeNamespace(contentType), envelope);
            BuilderUtil.validateCharSetEncoding(charSetEncoding, builder.getDocument().getCharsetEncoding(), envelope.getNamespace().getNamespaceURI());
            return envelope;
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public OMElement processMIMEMessage(Attachments attachments, String contentType, MessageContext messageContext) throws AxisFault {
        String charSetEncoding = BuilderUtil.getCharSetEncoding(attachments.getRootPartContentType());
        if (charSetEncoding == null) {
            charSetEncoding = "UTF-8";
        }
        messageContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
        messageContext.setDoingSwA(true);
        InputStream in = attachments.getRootPartInputStream(false);
        attachments.removeDataHandler(attachments.getRootPartContentID());
        messageContext.setAttachmentMap(attachments);
        return this.processDocument(in, contentType, messageContext);
    }
}

