/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.nhttp.util.LatencyViewMBean;

public class LatencyView
implements LatencyViewMBean {
    private static final int SMALL_DATA_COLLECTION_PERIOD = 5;
    private static final int LARGE_DATA_COLLECTION_PERIOD = 300;
    private static final int SAMPLES_PER_MINUTE = 12;
    private static final int SAMPLES_PER_HOUR = 12;
    private AtomicLong lastLatency = new AtomicLong(0L);
    private Queue<Long> latencyDataQueue = new ConcurrentLinkedQueue<Long>();
    private Queue<Long> shortTermLatencyDataQueue = new LinkedList<Long>();
    private Queue<Long> longTermLatencyDataQueue = new LinkedList<Long>();
    private ScheduledExecutorService scheduler;
    private double allTimeAvgLatency = 0.0;
    private int count = 0;
    private Date resetTime = Calendar.getInstance().getTime();
    private String latencyMode;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LatencyView(final String latencyMode, String transportName) {
        this.latencyMode = latencyMode;
        this.name = "nio-" + transportName;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, latencyMode + "-" + LatencyView.this.name + "-latency-view");
            }
        });
        this.scheduler.scheduleAtFixedRate(new ShortTermDataCollector(), 5L, 5L, TimeUnit.SECONDS);
        this.scheduler.scheduleAtFixedRate(new LongTermDataCollector(), 300L, 300L, TimeUnit.SECONDS);
        boolean registered = false;
        try {
            registered = MBeanRegistrar.getInstance().registerMBean((Object)this, this.latencyMode, this.name);
        }
        finally {
            if (!registered) {
                this.scheduler.shutdownNow();
            }
        }
    }

    public void destroy() {
        MBeanRegistrar.getInstance().unRegisterMBean(this.latencyMode, this.name);
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
    }

    public void notifyTimes(long reqArrival, long reqDeparture, long resArrival, long resDeparture) {
        long latency = resDeparture - reqArrival - (resArrival - reqDeparture);
        this.lastLatency.set(latency);
        this.latencyDataQueue.offer(latency);
    }

    @Override
    public double getAllTimeAvgLatency() {
        return this.allTimeAvgLatency;
    }

    @Override
    public double getLastMinuteAvgLatency() {
        return this.getAverageLatencyByMinute(1);
    }

    @Override
    public double getLast5MinuteAvgLatency() {
        return this.getAverageLatencyByMinute(5);
    }

    @Override
    public double getLast15MinuteAvgLatency() {
        return this.getAverageLatencyByMinute(15);
    }

    @Override
    public double getLastHourAvgLatency() {
        return this.getAverageLatencyByHour(1);
    }

    @Override
    public double getLast8HourAvgLatency() {
        return this.getAverageLatencyByHour(8);
    }

    @Override
    public double getLast24HourAvgLatency() {
        return this.getAverageLatencyByHour(24);
    }

    @Override
    public void reset() {
        this.lastLatency.set(0L);
        this.allTimeAvgLatency = 0.0;
        this.latencyDataQueue.clear();
        this.shortTermLatencyDataQueue.clear();
        this.longTermLatencyDataQueue.clear();
        this.count = 0;
        this.resetTime = Calendar.getInstance().getTime();
    }

    @Override
    public Date getLastResetTime() {
        return this.resetTime;
    }

    private double getAverageLatencyByMinute(int n) {
        int samples = n * 12;
        double sum = 0.0;
        Long[] array = this.shortTermLatencyDataQueue.toArray(new Long[this.shortTermLatencyDataQueue.size()]);
        if (samples > array.length) {
            samples = array.length;
            for (int i = 0; i < array.length; ++i) {
                sum += (double)array[i].longValue();
            }
        } else {
            for (int i = 0; i < samples; ++i) {
                sum += (double)array[array.length - 1 - i].longValue();
            }
        }
        if (samples == 0) {
            return 0.0;
        }
        return sum / (double)samples;
    }

    private double getAverageLatencyByHour(int n) {
        int samples = n * 12;
        double sum = 0.0;
        Long[] array = this.longTermLatencyDataQueue.toArray(new Long[this.longTermLatencyDataQueue.size()]);
        if (samples > array.length) {
            samples = array.length;
            for (int i = 0; i < array.length; ++i) {
                sum += (double)array[i].longValue();
            }
        } else {
            for (int i = 0; i < samples; ++i) {
                sum += (double)array[array.length - 1 - i].longValue();
            }
        }
        if (samples == 0) {
            return 0.0;
        }
        return sum / (double)samples;
    }

    private class LongTermDataCollector
    implements Runnable {
        private LongTermDataCollector() {
        }

        @Override
        public void run() {
            long latency = LatencyView.this.lastLatency.get();
            if (LatencyView.this.longTermLatencyDataQueue.size() == 0 && latency == 0L) {
                return;
            }
            if (LatencyView.this.longTermLatencyDataQueue.size() == 288) {
                LatencyView.this.longTermLatencyDataQueue.remove();
            }
            LatencyView.this.longTermLatencyDataQueue.offer(latency);
        }
    }

    private class ShortTermDataCollector
    implements Runnable {
        private ShortTermDataCollector() {
        }

        @Override
        public void run() {
            long latency = LatencyView.this.lastLatency.get();
            int size = LatencyView.this.latencyDataQueue.size();
            if (size > 0) {
                long sum = 0L;
                for (int i = 0; i < size; ++i) {
                    sum += ((Long)LatencyView.this.latencyDataQueue.poll()).longValue();
                }
                LatencyView.this.allTimeAvgLatency = (LatencyView.this.allTimeAvgLatency * (double)LatencyView.this.count + (double)sum) / (double)(LatencyView.this.count + size);
                LatencyView.this.count = LatencyView.this.count + size;
            }
            if (LatencyView.this.shortTermLatencyDataQueue.size() == 0 && latency == 0L) {
                return;
            }
            if (LatencyView.this.shortTermLatencyDataQueue.size() == 180) {
                LatencyView.this.shortTermLatencyDataQueue.remove();
            }
            LatencyView.this.shortTermLatencyDataQueue.offer(latency);
        }
    }
}

