/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.AnonymousServiceFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.BlockingClientUtils;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.util.MessageHelper;

public class Axis2BlockingClient {
    private static final Log log = LogFactory.getLog(Axis2BlockingClient.class);
    private static final String DEFAULT_CLIENT_REPO = "./repository";
    private static final String DEFAULT_AXIS2_XML = "./repository/conf/axis2_blocking_client.xml";
    private ConfigurationContext configurationContext = null;
    private boolean initClientOptions = true;
    private boolean configurationContextCreated = false;

    public Axis2BlockingClient(String clientRepository, String axis2xml) {
        try {
            this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(clientRepository != null ? clientRepository : DEFAULT_CLIENT_REPO), (String)(axis2xml != null ? axis2xml : DEFAULT_AXIS2_XML));
            this.configurationContextCreated = true;
        }
        catch (AxisFault e) {
            this.handleException("Error initializing Axis2 Blocking Client", (Exception)((Object)e));
        }
    }

    public Axis2BlockingClient(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void cleanup() throws AxisFault {
        if (this.configurationContextCreated) {
            this.configurationContext.terminate();
        }
    }

    public MessageContext send(Endpoint endpoint, MessageContext synapseInMsgCtx) throws Exception {
        AbstractEndpoint abstractEndpoint;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start Sending the Message ");
        }
        if (endpoint instanceof IndirectEndpoint) {
            endpoint = ((IndirectEndpoint)endpoint).getRealEndpoint(synapseInMsgCtx);
        }
        if (!(abstractEndpoint = (AbstractEndpoint)endpoint).isLeafEndpoint()) {
            this.handleException("Endpoint type not supported. Only leaf endpoints are supported");
        }
        EndpointDefinition endpointDefinition = abstractEndpoint.getDefinition();
        org.apache.axis2.context.MessageContext axisInMsgCtx = ((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext();
        org.apache.axis2.context.MessageContext axisOutMsgCtx = new org.apache.axis2.context.MessageContext();
        String endpointReferenceValue = null;
        if (endpointDefinition.getAddress() != null) {
            endpointReferenceValue = endpointDefinition.getAddress();
        } else if (axisInMsgCtx.getTo() != null) {
            endpointReferenceValue = axisInMsgCtx.getTo().getAddress();
        } else {
            this.handleException("Service url, Endpoint or 'To' header is required");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("EPR is set to : " + endpointReferenceValue));
        }
        axisOutMsgCtx.setTo(new EndpointReference(endpointReferenceValue));
        if (endpointReferenceValue != null && endpointReferenceValue.startsWith("local")) {
            this.configurationContext = axisInMsgCtx.getConfigurationContext();
        }
        axisOutMsgCtx.setConfigurationContext(this.configurationContext);
        axisOutMsgCtx.setEnvelope(axisInMsgCtx.getEnvelope());
        BlockingClientUtils.fillMessageContext(endpointDefinition, axisOutMsgCtx, synapseInMsgCtx);
        Options clientOptions = this.initClientOptions ? new Options() : axisInMsgCtx.getOptions();
        BlockingClientUtils.fillClientOptions(endpointDefinition, clientOptions, synapseInMsgCtx);
        AxisService anonymousService = AnonymousServiceFactory.getAnonymousService(null, this.configurationContext.getAxisConfiguration(), endpointDefinition.isAddressingOn(), endpointDefinition.isSecurityOn(), false);
        anonymousService.getParent().addParameter("hiddenService", (Object)"true");
        ServiceGroupContext serviceGroupContext = new ServiceGroupContext(this.configurationContext, (AxisServiceGroup)anonymousService.getParent());
        ServiceContext serviceCtx = serviceGroupContext.getServiceContext(anonymousService);
        axisOutMsgCtx.setServiceContext(serviceCtx);
        boolean isOutOnly = this.isOutOnly(synapseInMsgCtx, axisOutMsgCtx);
        try {
            if (isOutOnly) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"invoking service in OUT_ONLY manner");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"invoking service in OUT_IN manner");
                }
                org.apache.axis2.context.MessageContext result = this.sendReceive(axisOutMsgCtx, clientOptions, anonymousService, serviceCtx);
                synapseInMsgCtx.setEnvelope(result.getEnvelope());
                synapseInMsgCtx.setProperty("HTTP_SC", result.getProperty("transport.http.statusCode"));
                return synapseInMsgCtx;
            }
            this.sendRobust(axisOutMsgCtx, clientOptions, anonymousService, serviceCtx);
        }
        catch (Exception ex) {
            synapseInMsgCtx.setProperty("blocking.client.error", "true");
            axisOutMsgCtx.getTransportOut().getSender().cleanup(axisOutMsgCtx);
            if (!isOutOnly) {
                if (ex instanceof AxisFault) {
                    AxisFault fault = (AxisFault)((Object)ex);
                    if (fault.getFaultCode() != null) {
                        synapseInMsgCtx.setProperty("ERROR_CODE", fault.getFaultCode().getLocalPart());
                    }
                    synapseInMsgCtx.setProperty("ERROR_MESSAGE", fault.getMessage());
                    if (fault.getDetail() != null) {
                        synapseInMsgCtx.setProperty("ERROR_DETAIL", fault.getDetail());
                    }
                    synapseInMsgCtx.setProperty("ERROR_EXCEPTION", ex);
                    org.apache.axis2.context.MessageContext faultMC = fault.getFaultMessageContext();
                    if (faultMC != null) {
                        synapseInMsgCtx.setProperty("HTTP_SC", faultMC.getProperty("transport.http.statusCode"));
                        synapseInMsgCtx.setEnvelope(faultMC.getEnvelope());
                    }
                }
                return synapseInMsgCtx;
            }
            this.handleException("Error sending Message to url : " + ((AbstractEndpoint)endpoint).getDefinition().getAddress());
        }
        return null;
    }

    private void sendRobust(org.apache.axis2.context.MessageContext axisOutMsgCtx, Options clientOptions, AxisService anonymousService, ServiceContext serviceCtx) throws AxisFault {
        AxisOperation axisAnonymousOperation = anonymousService.getOperation(new QName("anonOutonlyOp"));
        OperationClient operationClient = axisAnonymousOperation.createClient(serviceCtx, clientOptions);
        operationClient.addMessageContext(axisOutMsgCtx);
        axisOutMsgCtx.setAxisMessage(axisAnonymousOperation.getMessage("Out"));
        operationClient.execute(true);
        axisOutMsgCtx.getTransportOut().getSender().cleanup(axisOutMsgCtx);
    }

    private org.apache.axis2.context.MessageContext sendReceive(org.apache.axis2.context.MessageContext axisOutMsgCtx, Options clientOptions, AxisService anonymousService, ServiceContext serviceCtx) throws AxisFault {
        AxisOperation axisAnonymousOperation = anonymousService.getOperation(new QName("anonOutInOp"));
        OperationClient operationClient = axisAnonymousOperation.createClient(serviceCtx, clientOptions);
        operationClient.addMessageContext(axisOutMsgCtx);
        axisOutMsgCtx.setAxisMessage(axisAnonymousOperation.getMessage("Out"));
        operationClient.execute(true);
        org.apache.axis2.context.MessageContext resultMsgCtx = operationClient.getMessageContext("In");
        org.apache.axis2.context.MessageContext returnMsgCtx = new org.apache.axis2.context.MessageContext();
        returnMsgCtx.setEnvelope(MessageHelper.cloneSOAPEnvelope(resultMsgCtx.getEnvelope()));
        returnMsgCtx.setProperty("transport.http.statusCode", resultMsgCtx.getProperty("transport.http.statusCode"));
        axisOutMsgCtx.getTransportOut().getSender().cleanup(axisOutMsgCtx);
        return returnMsgCtx;
    }

    private boolean isOutOnly(MessageContext messageIn, org.apache.axis2.context.MessageContext axis2Ctx) {
        return "true".equals(messageIn.getProperty("OUT_ONLY")) || axis2Ctx.getOperationContext() != null && "http://www.w3.org/ns/wsdl/in-only".equals(axis2Ctx.getOperationContext().getAxisOperation().getMessageExchangePattern());
    }

    public void setInitClientOptions(boolean initClientOptions) {
        this.initClientOptions = initClientOptions;
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

