/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfigurationDetectionStrategy;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsReporter;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;

public class SynapseMessageReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(SynapseMessageReceiver.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        boolean traceOrDebugOn;
        MessageContext synCtx = MessageContextCreatorForAxis2.getSynapseMessageContext(mc);
        StatisticsReporter.reportForComponent(synCtx, AspectConfigurationDetectionStrategy.getAspectConfiguration(synCtx), ComponentType.PROXYSERVICE);
        boolean traceOn = synCtx.getMainSequence().getTraceState() == 1;
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Synapse received a new message for message mediation...");
            this.traceOrDebug(traceOn, "Received To: " + (mc.getTo() != null ? mc.getTo().getAddress() : "null"));
            this.traceOrDebug(traceOn, "SOAPAction: " + (mc.getSoapAction() != null ? mc.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (mc.getWSAAction() != null ? mc.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                String[] cids = mc.getAttachmentMap().getAllContentIDs();
                if (cids != null && cids.length > 0) {
                    for (String cid : cids) {
                        trace.trace((Object)("Attachment : " + cid));
                    }
                }
                trace.trace((Object)("Envelope : " + mc.getEnvelope()));
            }
        }
        Log serviceLog = LogFactory.getLog((String)"SERVICE_LOGGER.__SynapseService");
        ((Axis2MessageContext)synCtx).setServiceLog(serviceLog);
        try {
            synCtx.getEnvironment().injectMessage(synCtx);
        }
        catch (SynapseException syne) {
            if (!synCtx.getFaultStack().isEmpty()) {
                this.warn(traceOn, "Executing fault handler due to exception encountered", synCtx);
                synCtx.getFaultStack().pop().handleFault(synCtx, syne);
            } else {
                this.warn(traceOn, "Exception encountered but no fault handler found - message dropped", synCtx);
            }
        }
        finally {
            StatisticsReporter.endReportForAllOnRequestProcessed(synCtx);
        }
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    private void warn(boolean traceOn, String msg, MessageContext msgContext) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.warn((Object)msg);
        }
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
    }
}

