/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class ScalarObjectFactory {
    public static ScalarObject createScalarObject(Expression.ValueType vt, String value) {
        switch (vt) {
            case INT: {
                return new IntObject(UtilFunctions.parseToLong(value));
            }
            case DOUBLE: {
                return new DoubleObject(Double.parseDouble(value));
            }
            case BOOLEAN: {
                return new BooleanObject(Boolean.parseBoolean(value));
            }
            case STRING: {
                return new StringObject(value);
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Expression.ValueType vt, Object obj) {
        switch (vt) {
            case BOOLEAN: {
                return new BooleanObject((Boolean)obj);
            }
            case INT: {
                return new IntObject((Long)obj);
            }
            case DOUBLE: {
                return new DoubleObject((Double)obj);
            }
            case STRING: {
                return new StringObject((String)obj);
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Expression.ValueType vt, double value) {
        switch (vt) {
            case INT: {
                return new IntObject(UtilFunctions.toLong(value));
            }
            case DOUBLE: {
                return new DoubleObject(value);
            }
            case BOOLEAN: {
                return new BooleanObject(value != 0.0);
            }
            case STRING: {
                return new StringObject(String.valueOf(value));
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Expression.ValueType vt, ScalarObject so) {
        switch (vt) {
            case DOUBLE: {
                return ScalarObjectFactory.castToDouble(so);
            }
            case INT: {
                return ScalarObjectFactory.castToLong(so);
            }
            case BOOLEAN: {
                return new BooleanObject(so.getBooleanValue());
            }
            case STRING: {
                return new StringObject(so.getStringValue());
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(LiteralOp lit) {
        return ScalarObjectFactory.createScalarObject(lit.getValueType(), lit);
    }

    public static ScalarObject createScalarObject(Expression.ValueType vt, LiteralOp lit) {
        switch (vt) {
            case DOUBLE: {
                return new DoubleObject(lit.getDoubleValue());
            }
            case INT: {
                return new IntObject(lit.getLongValue());
            }
            case BOOLEAN: {
                return new BooleanObject(lit.getBooleanValue());
            }
            case STRING: {
                return new StringObject(lit.getStringValue());
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static LiteralOp createLiteralOp(ScalarObject so) {
        switch (so.getValueType()) {
            case DOUBLE: {
                return new LiteralOp(so.getDoubleValue());
            }
            case INT: {
                return new LiteralOp(so.getLongValue());
            }
            case BOOLEAN: {
                return new LiteralOp(so.getBooleanValue());
            }
            case STRING: {
                return new LiteralOp(so.getStringValue());
            }
        }
        throw new HopsException("Unsupported literal value type: " + (Object)((Object)so.getValueType()));
    }

    public static LiteralOp createLiteralOp(ScalarObject so, UnaryOp cast) {
        switch (cast.getOp()) {
            case CAST_AS_DOUBLE: {
                return new LiteralOp(ScalarObjectFactory.castToDouble(so).getDoubleValue());
            }
            case CAST_AS_INT: {
                return new LiteralOp(ScalarObjectFactory.castToLong(so).getLongValue());
            }
            case CAST_AS_BOOLEAN: {
                return new LiteralOp(so.getBooleanValue());
            }
        }
        return null;
    }

    public static IntObject castToLong(ScalarObject so) {
        return new IntObject(!(so instanceof StringObject) ? so.getLongValue() : UtilFunctions.toLong(Double.parseDouble(so.getStringValue())));
    }

    public static DoubleObject castToDouble(ScalarObject so) {
        return new DoubleObject(!(so instanceof StringObject) ? so.getDoubleValue() : Double.parseDouble(so.getStringValue()));
    }
}

