/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.AdaptivePartialBlock;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.PartialBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.data.TaggedAdaptivePartialBlock;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.util.UtilFunctions;

public class ReblockBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 5000000;
    private final long[][] _buff;
    private final int _bufflen;
    private int _count;
    private final long _rlen;
    private final long _clen;
    private final int _brlen;
    private final int _bclen;

    public ReblockBuffer(int buffersize, long rlen, long clen, int brlen, int bclen) {
        this._bufflen = Math.max(buffersize, 16);
        this._count = 0;
        this._buff = new long[this._bufflen][3];
        this._rlen = rlen;
        this._clen = clen;
        this._brlen = brlen;
        this._bclen = bclen;
    }

    public void appendCell(long r, long c, double v) {
        long tmp = Double.doubleToRawLongBits(v);
        this._buff[this._count][0] = r;
        this._buff[this._count][1] = c;
        this._buff[this._count][2] = tmp;
        ++this._count;
    }

    public void appendBlock(long r_offset, long c_offset, MatrixBlock inBlk, byte index, OutputCollector<Writable, Writable> out) throws IOException {
        if (inBlk.isInSparseFormat()) {
            Iterator<IJV> iter = inBlk.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                long tmp = Double.doubleToRawLongBits(cell.getV());
                this._buff[this._count][0] = r_offset + (long)cell.getI();
                this._buff[this._count][1] = c_offset + (long)cell.getJ();
                this._buff[this._count][2] = tmp;
                ++this._count;
                if (this._count != this._bufflen) continue;
                this.flushBuffer(index, out);
            }
        } else {
            int rlen = inBlk.getNumRows();
            int clen = inBlk.getNumColumns();
            for (int i = 0; i < rlen; ++i) {
                for (int j = 0; j < clen; ++j) {
                    double val = inBlk.getValueDenseUnsafe(i, j);
                    if (val == 0.0) continue;
                    long tmp = Double.doubleToRawLongBits(val);
                    this._buff[this._count][0] = r_offset + (long)i;
                    this._buff[this._count][1] = c_offset + (long)j;
                    this._buff[this._count][2] = tmp;
                    ++this._count;
                    if (this._count != this._bufflen) continue;
                    this.flushBuffer(index, out);
                }
            }
        }
    }

    public int getSize() {
        return this._count;
    }

    public int getCapacity() {
        return this._bufflen;
    }

    public void flushBuffer(byte index, OutputCollector<Writable, Writable> out) throws IOException {
        if (this._count == 0) {
            return;
        }
        Arrays.sort(this._buff, 0, this._count, new ReblockBufferComparator());
        long numBlocks = 0L;
        long cbi = -1L;
        long cbj = -1L;
        for (int i = 0; i < this._count; ++i) {
            long bi = UtilFunctions.computeBlockIndex(this._buff[i][0], this._brlen);
            long bj = UtilFunctions.computeBlockIndex(this._buff[i][1], this._bclen);
            if (bi == cbi && bj == cbj) continue;
            cbi = bi;
            cbj = bj;
            ++numBlocks;
        }
        long blockedSize = 16L * numBlocks + (long)(16 * this._count);
        long cellSize = 24 * this._count;
        boolean blocked = blockedSize <= cellSize;
        TaggedAdaptivePartialBlock outTVal = new TaggedAdaptivePartialBlock();
        AdaptivePartialBlock outVal = new AdaptivePartialBlock();
        MatrixIndexes tmpIx = new MatrixIndexes();
        outTVal.setTag(index);
        outTVal.setBaseObject(outVal);
        if (blocked) {
            boolean sparse = MatrixBlock.evalSparseFormatInMemory(this._brlen, this._bclen, (long)this._count / numBlocks);
            MatrixBlock tmpBlock = new MatrixBlock();
            cbi = -1L;
            cbj = -1L;
            for (int i = 0; i < this._count; ++i) {
                long bi = UtilFunctions.computeBlockIndex(this._buff[i][0], this._brlen);
                long bj = UtilFunctions.computeBlockIndex(this._buff[i][1], this._bclen);
                if (bi != cbi || bj != cbj) {
                    ReblockBuffer.outputBlock(out, tmpIx, outTVal, tmpBlock);
                    cbi = bi;
                    cbj = bj;
                    tmpIx.setIndexes(bi, bj);
                    tmpBlock.reset(UtilFunctions.computeBlockSize(this._rlen, bi, this._brlen), UtilFunctions.computeBlockSize(this._clen, bj, this._bclen), sparse);
                }
                int ci = UtilFunctions.computeCellInBlock(this._buff[i][0], this._brlen);
                int cj = UtilFunctions.computeCellInBlock(this._buff[i][1], this._bclen);
                double tmp = Double.longBitsToDouble(this._buff[i][2]);
                tmpBlock.appendValue(ci, cj, tmp);
            }
            ReblockBuffer.outputBlock(out, tmpIx, outTVal, tmpBlock);
        } else {
            PartialBlock tmpVal = new PartialBlock();
            outVal.set(tmpVal);
            for (int i = 0; i < this._count; ++i) {
                long bi = UtilFunctions.computeBlockIndex(this._buff[i][0], this._brlen);
                long bj = UtilFunctions.computeBlockIndex(this._buff[i][1], this._bclen);
                int ci = UtilFunctions.computeCellInBlock(this._buff[i][0], this._brlen);
                int cj = UtilFunctions.computeCellInBlock(this._buff[i][1], this._bclen);
                double tmp = Double.longBitsToDouble(this._buff[i][2]);
                tmpIx.setIndexes(bi, bj);
                tmpVal.set(ci, cj, tmp);
                out.collect((Object)tmpIx, (Object)outTVal);
            }
        }
        this._count = 0;
    }

    public List<IndexedMatrixValue> flushBufferToBinaryBlocks() throws IOException, DMLRuntimeException {
        if (this._count == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(this._buff, 0, this._count, new ReblockBufferComparator());
        long numBlocks = 0L;
        long cbi = -1L;
        long cbj = -1L;
        for (int i = 0; i < this._count; ++i) {
            long bi = UtilFunctions.computeBlockIndex(this._buff[i][0], this._brlen);
            long bj = UtilFunctions.computeBlockIndex(this._buff[i][1], this._bclen);
            if (bi == cbi && bj == cbj) continue;
            cbi = bi;
            cbj = bj;
            ++numBlocks;
        }
        ArrayList<IndexedMatrixValue> ret = new ArrayList<IndexedMatrixValue>();
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(this._brlen, this._bclen, (long)this._count / numBlocks);
        MatrixIndexes tmpIx = new MatrixIndexes();
        MatrixBlock tmpBlock = new MatrixBlock();
        cbi = -1L;
        cbj = -1L;
        for (int i = 0; i < this._count; ++i) {
            long bi = UtilFunctions.computeBlockIndex(this._buff[i][0], this._brlen);
            long bj = UtilFunctions.computeBlockIndex(this._buff[i][1], this._bclen);
            if (bi != cbi || bj != cbj) {
                ReblockBuffer.outputBlock(ret, tmpIx, tmpBlock);
                cbi = bi;
                cbj = bj;
                tmpIx = new MatrixIndexes(bi, bj);
                tmpBlock = new MatrixBlock(UtilFunctions.computeBlockSize(this._rlen, bi, this._brlen), UtilFunctions.computeBlockSize(this._clen, bj, this._bclen), sparse);
            }
            int ci = UtilFunctions.computeCellInBlock(this._buff[i][0], this._brlen);
            int cj = UtilFunctions.computeCellInBlock(this._buff[i][1], this._bclen);
            double tmp = Double.longBitsToDouble(this._buff[i][2]);
            tmpBlock.appendValue(ci, cj, tmp);
        }
        ReblockBuffer.outputBlock(ret, tmpIx, tmpBlock);
        this._count = 0;
        return ret;
    }

    private static void outputBlock(OutputCollector<Writable, Writable> out, MatrixIndexes key, TaggedAdaptivePartialBlock value, MatrixBlock block) throws IOException {
        if (key.getRowIndex() == -1L || key.getColumnIndex() == -1L) {
            return;
        }
        if (block.isInSparseFormat()) {
            block.sortSparseRows();
        }
        ((AdaptivePartialBlock)value.getBaseObject()).set(block);
        out.collect((Object)key, (Object)value);
    }

    private static void outputBlock(ArrayList<IndexedMatrixValue> out, MatrixIndexes key, MatrixBlock value) throws IOException, DMLRuntimeException {
        if (key.getRowIndex() == -1L || key.getColumnIndex() == -1L) {
            return;
        }
        if (value.isInSparseFormat()) {
            value.sortSparseRows();
        }
        value.examSparsity();
        if (value.isUltraSparse()) {
            value = new MatrixBlock(value, SparseBlock.Type.COO, false);
        }
        out.add(new IndexedMatrixValue(key, value));
    }

    private class ReblockBufferComparator
    implements Comparator<long[]> {
        private ReblockBufferComparator() {
        }

        @Override
        public int compare(long[] arg0, long[] arg1) {
            long bi0 = UtilFunctions.computeBlockIndex(arg0[0], ReblockBuffer.this._brlen);
            long bj0 = UtilFunctions.computeBlockIndex(arg0[1], ReblockBuffer.this._bclen);
            long bi1 = UtilFunctions.computeBlockIndex(arg1[0], ReblockBuffer.this._brlen);
            long bj1 = UtilFunctions.computeBlockIndex(arg1[1], ReblockBuffer.this._bclen);
            return bi0 < bi1 || bi0 == bi1 && bj0 < bj1 ? -1 : (bi0 == bi1 && bj0 == bj1 ? 0 : 1);
        }
    }
}

