/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderDelegationTokenExtension;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStorageLocation;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSLinkResolver;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.CorruptFileBlockIterator;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "HBase"})
@InterfaceStability.Unstable
public class DistributedFileSystem
extends FileSystem {
    private Path workingDir;
    private URI uri;
    private String homeDirPrefix = "/user";
    DFSClient dfs;
    private boolean verifyChecksum = true;

    @Override
    public String getScheme() {
        return "hdfs";
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        String host = uri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + uri);
        }
        this.homeDirPrefix = conf.get("dfs.user.home.dir.prefix", "/user");
        this.dfs = new DFSClient(uri, conf, this.statistics);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = this.getHomeDirectory();
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public long getDefaultBlockSize() {
        return this.dfs.getDefaultBlockSize();
    }

    @Override
    public short getDefaultReplication() {
        return this.dfs.getDefaultReplication();
    }

    @Override
    public void setWorkingDirectory(Path dir) {
        String result = this.fixRelativePart(dir).toUri().getPath();
        if (!DFSUtil.isValidName((String)result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.fixRelativePart(dir);
    }

    @Override
    public Path getHomeDirectory() {
        return this.makeQualified(new Path(this.homeDirPrefix + "/" + this.dfs.ugi.getShortUserName()));
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = file.toUri().getPath();
        if (!DFSUtil.isValidName((String)result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        return this.getFileBlockLocations(file.getPath(), start, len);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(p);
        return (BlockLocation[])new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @InterfaceStability.Unstable
    public BlockStorageLocation[] getFileBlockStorageLocations(List<BlockLocation> blocks) throws IOException, UnsupportedOperationException, InvalidBlockTokenException {
        return this.dfs.getBlockStorageLocations(blocks);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    public boolean recoverLease(Path f) throws IOException {
        Path absF = this.fixRelativePart(f);
        return (Boolean)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (FSDataInputStream)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, permission, overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), bufferSize, replication, blockSize, progress, null);
    }

    public HdfsDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, InetSocketAddress[] favoredNodes) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (HdfsDataOutputStream)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> cflags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    protected HdfsDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        this.statistics.incrementWriteOps(1);
        DFSOutputStream dfsos = this.dfs.primitiveCreate(this.getPathName(this.fixRelativePart(f)), absolutePermission, flag, true, replication, blockSize, progress, bufferSize, checksumOpt);
        return this.dfs.createWrappedOutputStream(dfsos, this.statistics);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        if (flag.contains((Object)CreateFlag.OVERWRITE)) {
            flag.add(CreateFlag.CREATE);
        }
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public boolean setReplication(Path src, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(src);
        return (Boolean)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public void setStoragePolicy(Path src, String policyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(src);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getStoragePolicies();
    }

    @Override
    public void concat(Path trg, Path[] psrcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(trg);
        Path[] srcs = new Path[psrcs.length];
        for (int i = 0; i < psrcs.length; ++i) {
            srcs[i] = this.fixRelativePart(psrcs[i]);
        }
        String[] srcsStr = new String[psrcs.length];
        try {
            for (int i = 0; i < psrcs.length; ++i) {
                srcsStr[i] = this.getPathName(srcs[i]);
            }
            this.dfs.concat(this.getPathName(trg), srcsStr);
        }
        catch (UnresolvedLinkException e) {
            int i;
            FileStatus stat = this.getFileLinkStatus(absF);
            if (stat.isSymlink()) {
                throw new IOException("Cannot concat with a symlink target: " + trg + " -> " + stat.getPath());
            }
            absF = this.fixRelativePart(stat.getPath());
            for (i = 0; i < psrcs.length; ++i) {
                stat = this.getFileLinkStatus(srcs[i]);
                if (stat.isSymlink()) {
                    throw new IOException("Cannot concat with a symlink src: " + psrcs[i] + " -> " + stat.getPath());
                }
                srcs[i] = this.fixRelativePart(stat.getPath());
            }
            for (i = 0; i < psrcs.length; ++i) {
                srcsStr[i] = this.getPathName(srcs[i]);
            }
            this.dfs.concat(this.getPathName(absF), srcsStr);
        }
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absSrc = this.fixRelativePart(src);
        Path absDst = this.fixRelativePart(dst);
        try {
            return this.dfs.rename(this.getPathName(absSrc), this.getPathName(absDst));
        }
        catch (UnresolvedLinkException e) {
            Path source = this.getFileLinkStatus(absSrc).getPath();
            return (Boolean)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absDst);
        }
    }

    @Override
    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absSrc = this.fixRelativePart(src);
        Path absDst = this.fixRelativePart(dst);
        try {
            this.dfs.rename(this.getPathName(absSrc), this.getPathName(absDst), options);
        }
        catch (UnresolvedLinkException e) {
            Path source = this.getFileLinkStatus(absSrc).getPath();
            new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absDst);
        }
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (Boolean)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (ContentSummary)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public void setQuota(Path src, long namespaceQuota, long diskspaceQuota) throws IOException {
        Path absF = this.fixRelativePart(src);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    private FileStatus[] listStatusInternal(Path p) throws IOException {
        String src = this.getPathName(p);
        DirectoryListing thisListing = this.dfs.listPaths(src, HdfsFileStatus.EMPTY_NAME);
        if (thisListing == null) {
            throw new FileNotFoundException("File " + p + " does not exist.");
        }
        HdfsFileStatus[] partialListing = thisListing.getPartialListing();
        if (!thisListing.hasMore()) {
            FileStatus[] stats = new FileStatus[partialListing.length];
            for (int i = 0; i < partialListing.length; ++i) {
                stats[i] = partialListing[i].makeQualified(this.getUri(), p);
            }
            this.statistics.incrementReadOps(1);
            return stats;
        }
        int totalNumEntries = partialListing.length + thisListing.getRemainingEntries();
        ArrayList<FileStatus> listing = new ArrayList<FileStatus>(totalNumEntries);
        for (HdfsFileStatus fileStatus : partialListing) {
            listing.add(fileStatus.makeQualified(this.getUri(), p));
        }
        this.statistics.incrementLargeReadOps(1);
        do {
            if ((thisListing = this.dfs.listPaths(src, thisListing.getLastName())) == null) {
                throw new FileNotFoundException("File " + p + " does not exist.");
            }
            for (HdfsFileStatus fileStatus : partialListing = thisListing.getPartialListing()) {
                listing.add(fileStatus.makeQualified(this.getUri(), p));
            }
            this.statistics.incrementLargeReadOps(1);
        } while (thisListing.hasMore());
        return listing.toArray(new FileStatus[listing.size()]);
    }

    @Override
    public FileStatus[] listStatus(Path p) throws IOException {
        Path absF = this.fixRelativePart(p);
        return (FileStatus[])new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(Path p, PathFilter filter) throws IOException {
        Path absF = this.fixRelativePart(p);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        return this.mkdirsInternal(f, permission, false);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mkdirsInternal(f, permission, true);
    }

    private boolean mkdirsInternal(Path f, FsPermission permission, boolean createParent) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (Boolean)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.primitiveMkdir(this.getPathName(f), absolutePermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.dfs.closeOutputStreams(false);
            super.close();
        }
        finally {
            this.dfs.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public DFSClient getClient() {
        return this.dfs;
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getDiskStatus();
    }

    @Deprecated
    public DiskStatus getDiskStatus() throws IOException {
        return new DiskStatus(this.dfs.getDiskStatus());
    }

    @Deprecated
    public long getRawCapacity() throws IOException {
        return this.dfs.getDiskStatus().getCapacity();
    }

    @Deprecated
    public long getRawUsed() throws IOException {
        return this.dfs.getDiskStatus().getUsed();
    }

    public long getMissingBlocksCount() throws IOException {
        return this.dfs.getMissingBlocksCount();
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.dfs.getUnderReplicatedBlocksCount();
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.dfs.getCorruptBlocksCount();
    }

    @Override
    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return new CorruptFileBlockIterator(this.dfs, path);
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return this.getDataNodeStats(HdfsConstants.DatanodeReportType.ALL);
    }

    public DatanodeInfo[] getDataNodeStats(HdfsConstants.DatanodeReportType type) throws IOException {
        return this.dfs.datanodeReport(type);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        return this.setSafeMode(action, false);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        return this.dfs.setSafeMode(action, isChecked);
    }

    public void saveNamespace() throws AccessControlException, IOException {
        this.dfs.saveNamespace();
    }

    public long rollEdits() throws AccessControlException, IOException {
        return this.dfs.rollEdits();
    }

    public boolean restoreFailedStorage(String arg) throws AccessControlException, IOException {
        return this.dfs.restoreFailedStorage(arg);
    }

    public void refreshNodes() throws IOException {
        this.dfs.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.dfs.finalizeUpgrade();
    }

    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        return this.dfs.rollingUpgrade(action);
    }

    public void metaSave(String pathname) throws IOException {
        this.dfs.metaSave(pathname);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.dfs.getServerDefaults();
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (FileStatus)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(link);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        FileStatus status = (FileStatus)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
        if (status.isSymlink()) {
            Path targetQual = FSLinkResolver.qualifySymlinkTarget((URI)this.getUri(), (Path)status.getPath(), (Path)status.getSymlink());
            status.setSymlink(targetQual);
        }
        return status;
    }

    @Override
    public Path getLinkTarget(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (Path)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    protected Path resolveLink(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        String target = this.dfs.getLinkTarget(this.getPathName(this.fixRelativePart(f)));
        if (target == null) {
            throw new FileNotFoundException("File does not exist: " + f.toString());
        }
        return new Path(target);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (FileChecksum)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (FileChecksum)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(p);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(p);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(p);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    protected int getDefaultPort() {
        return 8020;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        Token result = this.dfs.getDelegationToken(renewer == null ? null : new Text(renewer));
        return result;
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.dfs.setBalancerBandwidth(bandwidth);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.dfs.getCanonicalServiceName();
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        if (HAUtil.isLogicalUri((Configuration)this.getConf(), (URI)uri)) {
            return uri;
        }
        return NetUtils.getCanonicalUri((URI)uri, (int)this.getDefaultPort());
    }

    public boolean isInSafeMode() throws IOException {
        return this.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
    }

    public void allowSnapshot(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public void disallowSnapshot(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Path)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        return this.dfs.getSnapshottableDirListing();
    }

    @Override
    public void deleteSnapshot(Path snapshotDir, String snapshotName) throws IOException {
        Path absF = this.fixRelativePart(snapshotDir);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException {
        Path absF = this.fixRelativePart(snapshotDir);
        return (SnapshotDiffReport)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public boolean isFileClosed(Path src) throws IOException {
        Path absF = this.fixRelativePart(src);
        return (Boolean)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public long addCacheDirective(CacheDirectiveInfo info) throws IOException {
        return this.addCacheDirective(info, EnumSet.noneOf(CacheFlag.class));
    }

    public long addCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        Preconditions.checkNotNull(info.getPath());
        Path path = new Path(this.getPathName(this.fixRelativePart(info.getPath()))).makeQualified(this.getUri(), this.getWorkingDirectory());
        return this.dfs.addCacheDirective(new CacheDirectiveInfo.Builder(info).setPath(path).build(), flags);
    }

    public void modifyCacheDirective(CacheDirectiveInfo info) throws IOException {
        this.modifyCacheDirective(info, EnumSet.noneOf(CacheFlag.class));
    }

    public void modifyCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        if (info.getPath() != null) {
            info = new CacheDirectiveInfo.Builder(info).setPath(new Path(this.getPathName(this.fixRelativePart(info.getPath()))).makeQualified(this.getUri(), this.getWorkingDirectory())).build();
        }
        this.dfs.modifyCacheDirective(info, flags);
    }

    public void removeCacheDirective(long id) throws IOException {
        this.dfs.removeCacheDirective(id);
    }

    public RemoteIterator<CacheDirectiveEntry> listCacheDirectives(CacheDirectiveInfo filter) throws IOException {
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        if (filter.getPath() != null) {
            filter = new CacheDirectiveInfo.Builder(filter).setPath(new Path(this.getPathName(this.fixRelativePart(filter.getPath())))).build();
        }
        RemoteIterator iter = this.dfs.listCacheDirectives(filter);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        CachePoolInfo.validate((CachePoolInfo)info);
        this.dfs.addCachePool(info);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        CachePoolInfo.validate((CachePoolInfo)info);
        this.dfs.modifyCachePool(info);
    }

    public void removeCachePool(String poolName) throws IOException {
        CachePoolInfo.validateName((String)poolName);
        this.dfs.removeCachePool(poolName);
    }

    public RemoteIterator<CachePoolEntry> listCachePools() throws IOException {
        return this.dfs.listCachePools();
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (AclStatus)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    public void createEncryptionZone(Path path, String keyName) throws IOException {
        this.dfs.createEncryptionZone(this.getPathName(path), keyName);
    }

    public EncryptionZone getEZForPath(Path path) throws IOException {
        Preconditions.checkNotNull(path);
        return this.dfs.getEZForPath(this.getPathName(path));
    }

    public RemoteIterator<EncryptionZone> listEncryptionZones() throws IOException {
        return this.dfs.listEncryptionZones();
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (byte[])new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Map)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Map)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (List)new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public void access(Path path, FsAction mode) throws IOException {
        Path absF = this.fixRelativePart(path);
        new /* Unavailable Anonymous Inner Class!! */.resolve((FileSystem)this, absF);
    }

    @Override
    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        Token<?>[] tokens = super.addDelegationTokens(renewer, credentials);
        if (this.dfs.getKeyProvider() != null) {
            KeyProviderDelegationTokenExtension keyProviderDelegationTokenExtension = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)this.dfs.getKeyProvider());
            Token[] kpTokens = keyProviderDelegationTokenExtension.addDelegationTokens(renewer, credentials);
            if (tokens != null && kpTokens != null) {
                Token[] all = new Token[tokens.length + kpTokens.length];
                System.arraycopy(tokens, 0, all, 0, tokens.length);
                System.arraycopy(kpTokens, 0, all, tokens.length, kpTokens.length);
                tokens = all;
            } else {
                tokens = tokens != null ? tokens : kpTokens;
            }
        }
        return tokens;
    }

    public DFSInotifyEventInputStream getInotifyEventStream() throws IOException {
        return this.dfs.getInotifyEventStream();
    }

    public DFSInotifyEventInputStream getInotifyEventStream(long lastReadTxid) throws IOException {
        return this.dfs.getInotifyEventStream(lastReadTxid);
    }

    static /* synthetic */ String access$000(DistributedFileSystem x0, Path x1) {
        return x0.getPathName(x1);
    }

    static /* synthetic */ boolean access$100(DistributedFileSystem x0) {
        return x0.verifyChecksum;
    }

    static /* synthetic */ FileSystem.Statistics access$200(DistributedFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileSystem.Statistics access$300(DistributedFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileSystem.Statistics access$400(DistributedFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileSystem.Statistics access$500(DistributedFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileStatus[] access$600(DistributedFileSystem x0, Path x1) throws IOException {
        return x0.listStatusInternal(x1);
    }

    static /* synthetic */ FileSystem.Statistics access$700(DistributedFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileSystem.Statistics access$800(DistributedFileSystem x0) {
        return x0.statistics;
    }

    static {
        HdfsConfiguration.init();
    }
}

