/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionDenseMultiBlock;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionDenseMultiBlockTransposed;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionDenseSingleBlock;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionDenseSingleBlockTransposed;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionSparse;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionSparseTransposed;
import org.apache.sysds.runtime.compress.readers.ReaderCompressedSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ReaderColumnSelection {
    protected static final Log LOG = LogFactory.getLog((String)ReaderColumnSelection.class.getName());
    protected int[] _colIndexes = null;
    protected int _numRows = -1;
    protected int _lastRow = -1;
    private DblArray nonZeroReturn;
    protected final DblArray emptyReturn = new DblArray();
    protected DblArray reusableReturn;
    protected double[] reusableArr;

    protected ReaderColumnSelection(int[] colIndexes, int numRows) {
        this._colIndexes = colIndexes;
        this._numRows = numRows;
        this._lastRow = -1;
        this.reusableArr = new double[colIndexes.length];
        this.reusableReturn = new DblArray(this.reusableArr);
    }

    public DblArray nextRow() {
        while ((this.nonZeroReturn = this.getNextRow()) != null && DblArray.isZero(this.nonZeroReturn)) {
        }
        return this.nonZeroReturn;
    }

    protected abstract DblArray getNextRow();

    public int getCurrentRowIndex() {
        return this._lastRow;
    }

    public static ReaderColumnSelection createReader(MatrixBlock rawBlock, int[] colIndices, boolean transposed) {
        if (colIndices.length <= 1) {
            throw new DMLCompressionException("Column selection reader should not be done on single column groups");
        }
        int[] in = (int[])colIndices.clone();
        if (rawBlock.isInSparseFormat() && transposed && rawBlock.getSparseBlock() != null) {
            return new ReaderColumnSelectionSparseTransposed(rawBlock, in);
        }
        if (rawBlock.isInSparseFormat() && rawBlock.getSparseBlock() != null) {
            return new ReaderColumnSelectionSparse(rawBlock, in);
        }
        if (rawBlock.getDenseBlock() != null && rawBlock.getDenseBlock().numBlocks() > 1) {
            return transposed ? new ReaderColumnSelectionDenseMultiBlockTransposed(rawBlock, in) : new ReaderColumnSelectionDenseMultiBlock(rawBlock, in);
        }
        if (rawBlock.getDenseBlock() != null) {
            return transposed ? new ReaderColumnSelectionDenseSingleBlockTransposed(rawBlock, in) : new ReaderColumnSelectionDenseSingleBlock(rawBlock, in);
        }
        throw new DMLCompressionException("Input Block was null");
    }

    public static ReaderColumnSelection createCompressedReader(CompressedMatrixBlock compBlock, int[] colIndices) {
        if (colIndices.length <= 1) {
            throw new DMLCompressionException("Compressed reader should not be done on single column groups");
        }
        int[] in = (int[])colIndices.clone();
        return new ReaderCompressedSelection(compBlock, in);
    }
}

