/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.junit.Assert;

public class ParameterBuilder {
    private static String _RS = "\\$\\$";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVariablesInScript(String strScriptPathName, HashMap<String, String> variables) {
        try {
            String strScript = strScriptPathName;
            String strTmpScript = strScript + "t";
            BufferedReader in = null;
            PrintWriter pw = null;
            try {
                String content;
                in = new BufferedReader(new InputStreamReader(new FileInputStream(strScript)));
                pw = new PrintWriter(new FileOutputStream(strTmpScript));
                Pattern unresolvedVars = Pattern.compile(_RS + ".*" + _RS);
                while ((content = in.readLine()) != null) {
                    for (Map.Entry<String, String> e : variables.entrySet()) {
                        String variable = e.getKey();
                        String val = e.getValue();
                        Pattern pattern = Pattern.compile(_RS + variable + _RS);
                        Matcher matcher = pattern.matcher(content);
                        while (matcher.find()) {
                            content = content.replaceFirst(matcher.group().replace("$", "\\$"), val);
                        }
                    }
                    Matcher matcher = unresolvedVars.matcher(content);
                    content = matcher.replaceAll("");
                    pw.println(content);
                }
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(pw);
                IOUtilFunctions.closeSilently(in);
                throw throwable;
            }
            IOUtilFunctions.closeSilently(pw);
            IOUtilFunctions.closeSilently(in);
        }
        catch (IOException e) {
            Assert.fail((String)("unable to set variables in dml script: " + e.getMessage()));
        }
    }

    public static void setVariablesInScript(String strScriptDirectory, String strScriptFile, HashMap<String, String> variables) {
        String strScript = strScriptDirectory + strScriptFile;
        ParameterBuilder.setVariablesInScript(strScript, variables);
    }
}

