/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.json4j.compat;

import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.apache.wink.json4j.compat.JSONArray;
import org.apache.wink.json4j.compat.JSONException;
import org.apache.wink.json4j.compat.JSONObject;
import org.apache.wink.json4j.compat.JSONStringer;
import org.apache.wink.json4j.compat.JSONWriter;

public abstract class JSONFactory {
    public static final JSONFactory newInstance() {
        String factory = System.getProperty("org.apache.wink.common.model.json.factory.impl");
        if (factory != null && factory.length() > 0) {
            try {
                Class<?> clazz = Class.forName(factory);
                return (JSONFactory)clazz.newInstance();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }

    public abstract JSONArray createJSONArray();

    public abstract JSONArray createJSONArray(Collection var1) throws JSONException;

    public abstract JSONArray createJSONArray(Collection var1, boolean var2) throws JSONException;

    public abstract JSONArray createJSONArray(Reader var1) throws JSONException;

    public abstract JSONArray createJSONArray(Object var1) throws JSONException;

    public abstract JSONArray createJSONArray(Object var1, boolean var2) throws JSONException;

    public abstract JSONArray createJSONArray(String var1) throws JSONException;

    public abstract JSONObject createJSONObject();

    public abstract JSONObject createJSONObject(Reader var1) throws JSONException;

    public abstract JSONObject createJSONObject(Map var1) throws JSONException;

    public abstract JSONObject createJSONObject(Map var1, boolean var2) throws JSONException;

    public abstract JSONObject createJSONObject(Object var1) throws JSONException;

    public abstract JSONObject createJSONObject(Object var1, boolean var2) throws JSONException;

    public abstract JSONObject createJSONObject(Object var1, String[] var2) throws JSONException;

    public abstract JSONObject createJSONObject(String var1) throws JSONException;

    public abstract JSONStringer createJSONStringer();

    public abstract JSONWriter createJSONWriter(Writer var1);
}

