/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.codegen.cplan.cuda;

import org.apache.sysds.hops.codegen.cplan.CNodeTernary;
import org.apache.sysds.hops.codegen.cplan.CodeTemplate;
import org.apache.sysds.runtime.matrix.data.LibMatrixNative;

public class Ternary
extends CodeTemplate {
    @Override
    public String getTemplate(CNodeTernary.TernaryType type, boolean sparse) {
        if (LibMatrixNative.isSinglePrecision()) {
            switch (type) {
                case PLUS_MULT: {
                    return "\tT %TMP% = %IN1% + %IN2% * %IN3%;\n";
                }
                case MINUS_MULT: {
                    return "\tT %TMP% = %IN1% - %IN2% * %IN3%;\n";
                }
                case BIASADD: {
                    return "\tT %TMP% = %IN1% + getValue(%IN2%, cix/%IN3%);\n";
                }
                case BIASMULT: {
                    return "\tT %TMP% = %IN1% * getValue(%IN2%, cix/%IN3%);\n";
                }
                case REPLACE: {
                    return "\tT %TMP% = (%IN1% == %IN2% || (isnan(%IN1%) && isnan(%IN2%))) ? %IN3% : %IN1%;\n";
                }
                case REPLACE_NAN: {
                    return "\tT %TMP% = isnan(%IN1%) ? %IN3% : %IN1%;\n";
                }
                case IFELSE: {
                    return "\tT %TMP% = (%IN1% != 0) ? %IN2% : %IN3%;\n";
                }
                case LOOKUP_RC1: {
                    return sparse ? "\tT %TMP% = getValue(%IN1v%, %IN1i%, ai, alen, %IN3%-1);\n" : "\t\tT %TMP% = %IN1%.val(rix, %IN3%-1);\n";
                }
                case LOOKUP_RVECT1: {
                    return "\t\tVector<T>& %TMP% = getVector(%IN1%, %IN2%, rix, %IN3%-1);\n";
                }
            }
            throw new RuntimeException("Invalid ternary type: " + this.toString());
        }
        switch (type) {
            case PLUS_MULT: {
                return "\tT %TMP% = %IN1% + %IN2% * %IN3%;\n";
            }
            case MINUS_MULT: {
                return "\tT %TMP% = %IN1% - %IN2% * %IN3%;\n";
            }
            case BIASADD: {
                return "\tT %TMP% = %IN1% + getValue(%IN2%, cix/%IN3%);\n";
            }
            case BIASMULT: {
                return "\tT %TMP% = %IN1% * getValue(%IN2%, cix/%IN3%);\n";
            }
            case REPLACE: {
                return "\tT %TMP% = (%IN1% == %IN2% || (isnan(%IN1%) && isnan(%IN2%))) ? %IN3% : %IN1%;\n";
            }
            case REPLACE_NAN: {
                return "\tT %TMP% = isnan(%IN1%) ? %IN3% : %IN1%;\n";
            }
            case IFELSE: {
                return "\tT %TMP% = (%IN1% != 0) ? %IN2% : %IN3%;\n";
            }
            case LOOKUP_RC1: {
                return sparse ? "\tT %TMP% = getValue(%IN1v%, %IN1i%, ai, alen, %IN3%-1);\n" : "\t\tT %TMP% = %IN1%.val(rix, %IN3%-1);\n";
            }
            case LOOKUP_RVECT1: {
                return "\t\tVector<T>& %TMP% = getVector(%IN1%, %IN2%, rix, %IN3%-1, this);\n";
            }
        }
        throw new RuntimeException("Invalid ternary type: " + this.toString());
    }
}

