/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.cost.HybridCostEstimator;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.cost.InstructionTypeCounter;
import org.apache.sysds.runtime.compress.workload.Op;
import org.apache.sysds.runtime.compress.workload.OpMetadata;
import org.apache.sysds.runtime.compress.workload.OpSided;
import org.apache.sysds.runtime.compress.workload.WTreeNode;
import org.apache.sysds.runtime.compress.workload.WTreeRoot;

public final class CostEstimatorBuilder
implements Serializable {
    private static final long serialVersionUID = 14L;
    protected static final Log LOG = LogFactory.getLog((String)CostEstimatorBuilder.class.getName());
    protected final InstructionTypeCounter counter = new InstructionTypeCounter();

    public CostEstimatorBuilder(WTreeRoot root) {
        if (root.isDecompressing()) {
            ++this.counter.decompressions;
        }
        for (Op o : root.getOps()) {
            CostEstimatorBuilder.addOp(1, o, this.counter);
        }
        for (WTreeNode n : root.getChildNodes()) {
            CostEstimatorBuilder.addNode(1, n, this.counter);
        }
    }

    protected ICostEstimate create(int nRows, int nCols, double sparsity, boolean isInSpark) {
        if (isInSpark) {
            return new HybridCostEstimator(nRows, nCols, sparsity, this.counter);
        }
        return new ComputationCostEstimator(nRows, nCols, sparsity, this.counter);
    }

    public InstructionTypeCounter getCounter() {
        return this.counter;
    }

    private static void addNode(int count, WTreeNode n, InstructionTypeCounter counter) {
        int mult = n.getReps();
        for (Op o : n.getOps()) {
            CostEstimatorBuilder.addOp(count * mult, o, counter);
        }
        for (WTreeNode nc : n.getChildNodes()) {
            CostEstimatorBuilder.addNode(count * mult, nc, counter);
        }
    }

    private static void addOp(int count, Op o, InstructionTypeCounter counter) {
        if (o.isDecompressing()) {
            if (o.isOverlapping()) {
                counter.overlappingDecompressions += count;
            } else {
                counter.decompressions += count;
            }
        }
        if (o.isDensifying()) {
            counter.isDensifying = true;
        }
        if (o instanceof OpSided) {
            OpSided os = (OpSided)o;
            if (os.isLeftMM()) {
                counter.leftMultiplications += count;
            } else if (os.isRightMM()) {
                counter.rightMultiplications += count;
            } else {
                counter.compressedMultiplications += count;
            }
        } else if (!(o instanceof OpMetadata)) {
            Hop h = o.getHop();
            if (h instanceof AggUnaryOp) {
                AggUnaryOp agop = (AggUnaryOp)o.getHop();
                switch (agop.getDirection()) {
                    case Row: {
                        counter.scans += count;
                        break;
                    }
                    default: {
                        counter.dictionaryOps += count;
                        break;
                    }
                }
            } else if (h instanceof IndexingOp) {
                IndexingOp idxO = (IndexingOp)h;
                if (idxO.isRowLowerEqualsUpper() && idxO.isColLowerEqualsUpper()) {
                    ++counter.indexing;
                } else if (idxO.isAllRows()) {
                    counter.dictionaryOps += count;
                }
            } else {
                counter.dictionaryOps += count;
            }
        }
    }

    public boolean shouldTryToCompress() {
        int numberOps = 0;
        numberOps += this.counter.scans + this.counter.leftMultiplications * 2 + this.counter.rightMultiplications * 2 + this.counter.compressedMultiplications * 4 + this.counter.dictionaryOps;
        int nrMultiplications = this.counter.leftMultiplications + this.counter.rightMultiplications + this.counter.compressedMultiplications;
        int nrDecompressions = this.counter.decompressions + this.counter.overlappingDecompressions * 2;
        if (this.counter.decompressions == 0 && this.counter.rightMultiplications == this.counter.overlappingDecompressions && (numberOps -= this.counter.decompressions + this.counter.overlappingDecompressions * 2) > 10) {
            return true;
        }
        if (nrDecompressions > nrMultiplications || nrDecompressions > 1 && nrMultiplications < 1) {
            return false;
        }
        return numberOps > 4;
    }

    public boolean shouldUseOverlap() {
        int decompressionsOverall = this.counter.overlappingDecompressions + this.counter.decompressions;
        return decompressionsOverall == 0 || decompressionsOverall * 10 < this.counter.leftMultiplications * 9 + this.counter.dictionaryOps;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.counter);
        return sb.toString();
    }
}

