/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.cost.InstructionTypeCounter;
import org.apache.sysds.runtime.compress.cost.MemoryCostEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class HybridCostEstimator
implements ICostEstimate {
    final ComputationCostEstimator costEstimator;
    final MemoryCostEstimator memoryCostEstimator;

    protected HybridCostEstimator(int nRows, int nCols, double sparsity, InstructionTypeCounter counts) {
        this.costEstimator = new ComputationCostEstimator(nRows, nCols, sparsity, counts);
        this.memoryCostEstimator = new MemoryCostEstimator(nRows, nCols, sparsity);
    }

    protected HybridCostEstimator(int nRows, int nCols, double sparsity, int scans, int decompressions, int overlappingDecompressions, int leftMultiplictions, int compressedMultiplication, int rightMultiplications, int dictioanaryOps, boolean isDensifying) {
        this.costEstimator = new ComputationCostEstimator(nRows, nCols, sparsity, scans, decompressions, overlappingDecompressions, leftMultiplictions, compressedMultiplication, rightMultiplications, dictioanaryOps, isDensifying);
        this.memoryCostEstimator = new MemoryCostEstimator(nRows, nCols, sparsity);
    }

    @Override
    public double getUncompressedCost(CompressedSizeInfoColGroup g) {
        double cost = this.costEstimator.getUncompressedCost(g);
        return cost;
    }

    @Override
    public double getCostOfColumnGroup(CompressedSizeInfoColGroup g) {
        double cost = this.costEstimator.getCostOfColumnGroup(g);
        return cost *= this.calculateCompressionRatio(g);
    }

    private double calculateCompressionRatio(CompressedSizeInfoColGroup g) {
        double denseSize = this.memoryCostEstimator.getUncompressedCost(g);
        double compressedSize = this.memoryCostEstimator.getCostOfColumnGroup(g);
        return compressedSize / denseSize;
    }

    @Override
    public boolean shouldAnalyze(CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        return true;
    }
}

