/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.DCounts;
import org.apache.sysds.runtime.compress.utils.Util;

public class DoubleCountHashMap {
    protected static final Log LOG = LogFactory.getLog((String)DoubleCountHashMap.class.getName());
    protected static final int RESIZE_FACTOR = 2;
    protected static final float LOAD_FACTOR = 0.8f;
    public static int hashMissCount = 0;
    protected int _size = -1;
    private Bucket[] _data = null;

    public DoubleCountHashMap(int init_capacity) {
        this._data = new Bucket[Util.getPow2(init_capacity)];
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    private void appendValue(DCounts ent) {
        int hash = DoubleCountHashMap.hash(ent.key);
        int ix = DoubleCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        if (l == null) {
            this._data[ix] = new Bucket(ent);
        } else {
            while (l != null) {
                l = l.n;
            }
            Bucket ob = this._data[ix];
            this._data[ix] = new Bucket(ent);
            this._data[ix].n = ob;
        }
        ++this._size;
    }

    public void increment(double key) {
        int hash = DoubleCountHashMap.hash(key);
        int ix = DoubleCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        while (l != null && l.v.key != key) {
            ++hashMissCount;
            l = l.n;
        }
        if (l == null) {
            Bucket ob = this._data[ix];
            this._data[ix] = new Bucket(new DCounts(key));
            this._data[ix].n = ob;
            ++this._size;
        } else {
            ++l.v.count;
        }
        if ((float)this._size >= 0.8f * (float)this._data.length) {
            this.resize();
        }
    }

    public int get(double key) {
        int hash = DoubleCountHashMap.hash(key);
        int ix = DoubleCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        while (l.v.key != key) {
            l = l.n;
        }
        return l.v.count;
    }

    public ArrayList<DCounts> extractValues() {
        ArrayList<DCounts> ret = new ArrayList<DCounts>(this._size);
        for (Bucket e : this._data) {
            while (e != null) {
                ret.add(e.v);
                e = e.n;
            }
        }
        return ret;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            return;
        }
        Bucket[] olddata = this._data;
        this._data = new Bucket[this._data.length * 2];
        this._size = 0;
        for (Bucket e : olddata) {
            while (e != null) {
                this.appendValue(e.v);
                e = e.n;
            }
        }
    }

    private static int hash(double key) {
        long bits = Double.doubleToRawLongBits(key);
        int h = (int)(bits ^ bits >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + this.hashCode());
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == null) continue;
            sb.append(", " + this._data[i]);
        }
        return sb.toString();
    }

    public void reset(int size) {
        int p2 = Util.getPow2(size);
        if (this._data.length > 2 * p2) {
            this._data = new Bucket[p2];
        } else {
            Arrays.fill(this._data, null);
        }
        this._size = 0;
    }

    protected class Bucket {
        protected DCounts v;
        protected Bucket n = null;

        protected Bucket(DCounts v) {
            this.v = v;
        }

        public String toString() {
            if (this.n == null) {
                return this.v.toString();
            }
            return this.v.toString() + "->" + this.n.toString();
        }
    }
}

