/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;

public class WeightedSquaredLoss
extends Lop {
    public static final String OPCODE = "mapwsloss";
    public static final String OPCODE_CP = "wsloss";
    private int _numThreads = 1;
    private WeightsType _weightsType = null;

    public WeightedSquaredLoss(Lop input1, Lop input2, Lop input3, Lop input4, Types.DataType dt, Types.ValueType vt, WeightsType wt, Types.ExecType et) {
        super(Lop.Type.WeightedSquaredLoss, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        this.addInput(input4);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        input4.addOutput(this);
        this._weightsType = wt;
        this.setupLopProperties(et);
    }

    @Override
    public String toString() {
        return "Operation = WeightedSquaredLoss";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String input4, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this.getExecType() == Types.ExecType.CP) {
            sb.append(OPCODE_CP);
        } else {
            sb.append(OPCODE);
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(3).prepInputOperand(input4));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._weightsType);
        if (this.getExecType() == Types.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    public static enum WeightsType {
        POST,
        POST_NZ,
        PRE,
        NONE;


        public boolean hasFourInputs() {
            return this == POST || this == PRE;
        }
    }
}

