/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;
import scala.Tuple2;

public class CumulativeOffsetSPInstruction
extends BinarySPInstruction {
    private UnaryOperator _uop = null;
    private boolean _cumsumprod = false;
    private final double _initValue;
    private final boolean _broadcast;

    private CumulativeOffsetSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, double init, boolean broadcast, String opcode, String istr) {
        super(SPInstruction.SPType.CumsumOffset, op, in1, in2, out, opcode, istr);
        if ("bcumoffk+".equals(opcode)) {
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucumk+"));
        } else if ("bcumoff*".equals(opcode)) {
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucum*"));
        } else if ("bcumoff+*".equals(opcode)) {
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucumk+*"));
            this._cumsumprod = true;
        } else if ("bcumoffmin".equals(opcode)) {
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucummin"));
        } else if ("bcumoffmax".equals(opcode)) {
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucummax"));
        }
        this._initValue = init;
        this._broadcast = broadcast;
    }

    public static CumulativeOffsetSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        double init = Double.parseDouble(parts[4]);
        boolean broadcast = Boolean.parseBoolean(parts[5]);
        return new CumulativeOffsetSPInstruction(null, in1, in2, out, init, broadcast, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        boolean broadcast;
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        DataCharacteristics mc1 = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mc2 = sec.getDataCharacteristics(this.input2.getName());
        long rlen = mc2.getRows();
        int blen = mc2.getBlocksize();
        JavaPairRDD<MatrixIndexes, MatrixBlock> inData = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD joined = null;
        boolean bl = broadcast = this._broadcast && !SparkUtils.isHashPartitioned(inData);
        if (broadcast) {
            PartitionedBroadcast<MatrixBlock> inAgg = sec.getBroadcastForVariable(this.input2.getName());
            joined = inData.mapToPair((PairFunction)new RDDCumSplitLookupFunction(inAgg, this._initValue, rlen, blen));
        } else {
            joined = inData.join(sec.getBinaryMatrixBlockRDDHandleForVariable(this.input2.getName()).flatMapToPair((PairFlatMapFunction)new RDDCumSplitFunction(this._initValue, rlen, blen)));
        }
        JavaPairRDD out = joined.mapValues((Function)new RDDCumOffsetFunction(this._uop, this._cumsumprod));
        if (this._cumsumprod) {
            sec.getDataCharacteristics(this.output.getName()).set(mc1.getRows(), 1L, mc1.getBlocksize(), mc1.getBlocksize());
        } else {
            this.updateUnaryOutputDataCharacteristics(sec);
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineage(this.output.getName(), this.input2.getName(), broadcast);
    }

    private static class RDDCumOffsetFunction
    implements Function<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock> {
        private static final long serialVersionUID = -5804080263258064743L;
        private final UnaryOperator _uop;
        private final boolean _cumsumprod;

        public RDDCumOffsetFunction(UnaryOperator uop, boolean cumsumprod) {
            this._uop = uop;
            this._cumsumprod = cumsumprod;
        }

        public MatrixBlock call(Tuple2<MatrixBlock, MatrixBlock> arg0) throws Exception {
            MatrixBlock dblkIn = (MatrixBlock)arg0._1();
            MatrixBlock oblkIn = (MatrixBlock)arg0._2();
            MatrixBlock blkOut = new MatrixBlock(dblkIn.getNumRows(), this._cumsumprod ? 1 : dblkIn.getNumColumns(), false);
            return LibMatrixAgg.cumaggregateUnaryMatrix(dblkIn, blkOut, this._uop, DataConverter.convertToDoubleVector(oblkIn, false, ((Builtin)this._uop.fn).bFunc == Builtin.BuiltinCode.CUMSUM));
        }
    }

    private static class RDDCumSplitLookupFunction
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>> {
        private static final long serialVersionUID = -2785629043886477479L;
        private final PartitionedBroadcast<MatrixBlock> _pbc;
        private final double _initValue;
        private final int _blen;

        public RDDCumSplitLookupFunction(PartitionedBroadcast<MatrixBlock> pbc, double initValue, long rlen, int blen) {
            this._pbc = pbc;
            this._initValue = initValue;
            this._blen = blen;
        }

        public Tuple2<MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock blkIn = (MatrixBlock)arg0._2();
            long brix = UtilFunctions.computeBlockIndex(ixIn.getRowIndex() - 1L, this._blen);
            int rix = UtilFunctions.computeCellInBlock(ixIn.getRowIndex() - 1L, this._blen);
            MatrixBlock off = ixIn.getRowIndex() == 1L ? new MatrixBlock(1, blkIn.getNumColumns(), this._initValue) : this._pbc.getBlock((int)brix, (int)ixIn.getColumnIndex()).slice(rix, rix);
            return new Tuple2((Object)ixIn, (Object)new Tuple2((Object)blkIn, (Object)off));
        }
    }

    private static class RDDCumSplitFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -8407407527406576965L;
        private double _initValue = 0.0;
        private int _blen = -1;
        private long _lastRowBlockIndex;

        public RDDCumSplitFunction(double initValue, long rlen, int blen) {
            this._initValue = initValue;
            this._blen = blen;
            this._lastRowBlockIndex = (long)Math.ceil((double)rlen / (double)blen);
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            boolean lastBlk;
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock blkIn = (MatrixBlock)arg0._2();
            long rixOffset = (ixIn.getRowIndex() - 1L) * (long)this._blen;
            boolean firstBlk = ixIn.getRowIndex() == 1L;
            boolean bl = lastBlk = ixIn.getRowIndex() == this._lastRowBlockIndex;
            if (firstBlk) {
                MatrixIndexes tmpix = new MatrixIndexes(1L, ixIn.getColumnIndex());
                MatrixBlock tmpblk = new MatrixBlock(1, blkIn.getNumColumns(), blkIn.isInSparseFormat());
                if (this._initValue != 0.0) {
                    for (int j = 0; j < blkIn.getNumColumns(); ++j) {
                        tmpblk.appendValue(0, j, this._initValue);
                    }
                }
                ret.add(new Tuple2((Object)tmpix, (Object)tmpblk));
            }
            for (int i = 0; i < blkIn.getNumRows(); ++i) {
                if (lastBlk && i == blkIn.getNumRows() - 1) continue;
                MatrixIndexes tmpix = new MatrixIndexes(rixOffset + (long)i + 2L, ixIn.getColumnIndex());
                MatrixBlock tmpblk = new MatrixBlock(1, blkIn.getNumColumns(), blkIn.isInSparseFormat());
                blkIn.slice(i, i, 0, blkIn.getNumColumns() - 1, tmpblk);
                ret.add(new Tuple2((Object)tmpix, (Object)tmpblk));
            }
            return ret.iterator();
        }
    }
}

