/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.functions;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import scala.Tuple2;

public class ReplicateVectorFunction
implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
    private static final long serialVersionUID = -1505557561471236851L;
    private boolean _byRow;
    private long _numReplicas;

    public ReplicateVectorFunction(boolean byRow, long numReplicas) {
        this._byRow = byRow;
        this._numReplicas = numReplicas;
    }

    public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
        MatrixIndexes ix = (MatrixIndexes)arg0._1();
        MatrixBlock mb = (MatrixBlock)arg0._2();
        if (this._byRow && (ix.getRowIndex() != 1L || mb.getNumRows() > 1)) {
            throw new Exception("Expected a row vector in ReplicateVector");
        }
        if (!(this._byRow || ix.getColumnIndex() == 1L && mb.getNumColumns() <= 1)) {
            throw new Exception("Expected a column vector in ReplicateVector");
        }
        ArrayList<Tuple2> retVal = new ArrayList<Tuple2>();
        int i = 1;
        while ((long)i <= this._numReplicas) {
            if (this._byRow) {
                retVal.add(new Tuple2((Object)new MatrixIndexes(i, ix.getColumnIndex()), (Object)mb));
            } else {
                retVal.add(new Tuple2((Object)new MatrixIndexes(ix.getRowIndex(), i), (Object)mb));
            }
            ++i;
        }
        return retVal.iterator();
    }
}

