/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy;

import java.util.EnumMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.privacy.DMLPrivacyException;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.PrivacyUtils;

public class PrivacyMonitor {
    private static final EnumMap<PrivacyConstraint.PrivacyLevel, LongAdder> checkedConstraints;
    private static boolean checkPrivacy;

    public static EnumMap<PrivacyConstraint.PrivacyLevel, LongAdder> getCheckedConstraints() {
        return checkedConstraints;
    }

    private static void incrementCheckedConstraints(PrivacyConstraint.PrivacyLevel privacyLevel) {
        if (privacyLevel == null) {
            throw new NullPointerException("Cannot increment checked constraints log: Privacy level is null.");
        }
        checkedConstraints.get((Object)privacyLevel).increment();
    }

    private static void updateCheckedConstraintsLog(PrivacyConstraint privacyConstraint) {
        if (checkPrivacy) {
            if (privacyConstraint.privacyLevel != PrivacyConstraint.PrivacyLevel.None) {
                PrivacyMonitor.incrementCheckedConstraints(privacyConstraint.privacyLevel);
            }
            if (PrivacyUtils.privacyConstraintFineGrainedActivated(privacyConstraint)) {
                int privateNum = privacyConstraint.getFineGrainedPrivacy().getDataRangesOfPrivacyLevel(PrivacyConstraint.PrivacyLevel.Private).length;
                int aggregateNum = privacyConstraint.getFineGrainedPrivacy().getDataRangesOfPrivacyLevel(PrivacyConstraint.PrivacyLevel.PrivateAggregation).length;
                checkedConstraints.get((Object)PrivacyConstraint.PrivacyLevel.Private).add(privateNum);
                checkedConstraints.get((Object)PrivacyConstraint.PrivacyLevel.PrivateAggregation).add(aggregateNum);
            }
        }
    }

    public static void clearCheckedConstraints() {
        checkedConstraints.replaceAll((k, v) -> new LongAdder());
    }

    public static void setCheckPrivacy(boolean checkPrivacyParam) {
        checkPrivacy = checkPrivacyParam;
    }

    public static Data handlePrivacy(Data dataObject) {
        if (dataObject == null) {
            return null;
        }
        PrivacyConstraint privacyConstraint = dataObject.getPrivacyConstraint();
        if (PrivacyUtils.someConstraintSetUnary(privacyConstraint)) {
            PrivacyMonitor.updateCheckedConstraintsLog(privacyConstraint);
            throw new DMLPrivacyException("Cannot share variable, since the privacy constraint of the requested variable is activated");
        }
        dataObject.setPrivacyConstraints(null);
        return dataObject;
    }

    static {
        checkPrivacy = false;
        checkedConstraints = new EnumMap(PrivacyConstraint.PrivacyLevel.class);
        for (PrivacyConstraint.PrivacyLevel level : PrivacyConstraint.PrivacyLevel.values()) {
            checkedConstraints.put(level, new LongAdder());
        }
    }
}

