/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spark_project.jetty.client.HttpClient;
import org.spark_project.jetty.client.HttpContentResponse;
import org.spark_project.jetty.client.HttpConversation;
import org.spark_project.jetty.client.HttpRequest;
import org.spark_project.jetty.client.HttpResponseException;
import org.spark_project.jetty.client.ProtocolHandler;
import org.spark_project.jetty.client.ResponseNotifier;
import org.spark_project.jetty.client.api.Authentication;
import org.spark_project.jetty.client.api.Request;
import org.spark_project.jetty.client.api.Response;
import org.spark_project.jetty.client.api.Result;
import org.spark_project.jetty.client.util.BufferingResponseListener;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public abstract class AuthenticationProtocolHandler
implements ProtocolHandler {
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 4096;
    public static final Logger LOG = Log.getLogger(AuthenticationProtocolHandler.class);
    private static final Pattern AUTHENTICATE_PATTERN = Pattern.compile("([^\\s]+)\\s+realm=\"([^\"]+)\"(.*)", 2);
    private static final String AUTHENTICATION_ATTRIBUTE = AuthenticationProtocolHandler.class.getName() + ".authentication";
    private final HttpClient client;
    private final int maxContentLength;
    private final ResponseNotifier notifier;

    protected AuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        this.client = client;
        this.maxContentLength = maxContentLength;
        this.notifier = new ResponseNotifier();
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    protected abstract HttpHeader getAuthenticateHeader();

    protected abstract HttpHeader getAuthorizationHeader();

    protected abstract URI getAuthenticationURI(Request var1);

    @Override
    public Response.Listener getResponseListener() {
        return new AuthenticationListener();
    }

    private class AuthenticationListener
    extends BufferingResponseListener {
        private AuthenticationListener() {
            super(AuthenticationProtocolHandler.this.maxContentLength);
        }

        @Override
        public void onComplete(Result result2) {
            HttpRequest request = (HttpRequest)result2.getRequest();
            HttpContentResponse response = new HttpContentResponse(result2.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
            if (result2.isFailed()) {
                Throwable failure = result2.getFailure();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge failed {}", failure);
                }
                this.forwardFailureComplete(request, result2.getRequestFailure(), response, result2.getResponseFailure());
                return;
            }
            HttpConversation conversation = request.getConversation();
            if (conversation.getAttribute(AUTHENTICATION_ATTRIBUTE) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bad credentials for {}", request);
                }
                this.forwardSuccessComplete(request, response);
                return;
            }
            HttpHeader header = AuthenticationProtocolHandler.this.getAuthenticateHeader();
            List<Authentication.HeaderInfo> headerInfos = this.parseAuthenticateHeader(response, header);
            if (headerInfos.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge without {} header", new Object[]{header});
                }
                this.forwardFailureComplete(request, null, response, new HttpResponseException("HTTP protocol violation: Authentication challenge without " + (Object)((Object)header) + " header", response));
                return;
            }
            Authentication authentication = null;
            Authentication.HeaderInfo headerInfo = null;
            URI uri = AuthenticationProtocolHandler.this.getAuthenticationURI(request);
            if (uri != null) {
                for (Authentication.HeaderInfo element : headerInfos) {
                    authentication = AuthenticationProtocolHandler.this.client.getAuthenticationStore().findAuthentication(element.getType(), uri, element.getRealm());
                    if (authentication == null) continue;
                    headerInfo = element;
                    break;
                }
            }
            if (authentication == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No authentication available for {}", request);
                }
                this.forwardSuccessComplete(request, response);
                return;
            }
            try {
                final Authentication.Result authnResult = authentication.authenticate(request, response, headerInfo, conversation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication result {}", authnResult);
                }
                if (authnResult == null) {
                    this.forwardSuccessComplete(request, response);
                    return;
                }
                conversation.setAttribute(AUTHENTICATION_ATTRIBUTE, true);
                Request newRequest = AuthenticationProtocolHandler.this.client.copyRequest(request, request.getURI());
                authnResult.apply(newRequest);
                newRequest.onResponseSuccess(new Response.SuccessListener(){

                    @Override
                    public void onSuccess(Response response) {
                        AuthenticationProtocolHandler.this.client.getAuthenticationStore().addAuthenticationResult(authnResult);
                    }
                }).send(null);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed", x);
                }
                this.forwardFailureComplete(request, null, response, x);
            }
        }

        private void forwardSuccessComplete(HttpRequest request, Response response) {
            HttpConversation conversation = request.getConversation();
            conversation.updateResponseListeners(null);
            AuthenticationProtocolHandler.this.notifier.forwardSuccessComplete(conversation.getResponseListeners(), request, response);
        }

        private void forwardFailureComplete(HttpRequest request, Throwable requestFailure, Response response, Throwable responseFailure) {
            HttpConversation conversation = request.getConversation();
            conversation.updateResponseListeners(null);
            AuthenticationProtocolHandler.this.notifier.forwardFailureComplete(conversation.getResponseListeners(), request, requestFailure, response, responseFailure);
        }

        private List<Authentication.HeaderInfo> parseAuthenticateHeader(Response response, HttpHeader header) {
            ArrayList<Authentication.HeaderInfo> result2 = new ArrayList<Authentication.HeaderInfo>();
            ArrayList<String> values2 = Collections.list(response.getHeaders().getValues(header.asString()));
            for (String value2 : values2) {
                Matcher matcher = AUTHENTICATE_PATTERN.matcher(value2);
                if (!matcher.matches()) continue;
                String type = matcher.group(1);
                String realm = matcher.group(2);
                String params = matcher.group(3);
                Authentication.HeaderInfo headerInfo = new Authentication.HeaderInfo(type, realm, params, AuthenticationProtocolHandler.this.getAuthorizationHeader());
                result2.add(headerInfo);
            }
            return result2;
        }
    }
}

