/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.protobuf.SysdsProtos;
import org.apache.sysds.runtime.io.FrameWriter;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.util.HDFSTool;

public class FrameWriterProto
extends FrameWriter {
    @Override
    public void writeFrameToHDFS(FrameBlock src, String fname, long rlen, long clen) throws IOException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Frame dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        this.writeProtoFrameToHDFS(path, job, src, rlen, clen);
    }

    protected void writeProtoFrameToHDFS(Path path, JobConf jobConf, FrameBlock src, long rlen, long clen) throws IOException {
        FileSystem fileSystem = IOUtilFunctions.getFileSystem(path, (Configuration)jobConf);
        this.writeProtoFrameToFile(path, fileSystem, src, 0, (int)rlen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fileSystem, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeProtoFrameToFile(Path path, FileSystem fileSystem, FrameBlock src, int lowerRowBound, int upperRowBound) throws IOException {
        FSDataOutputStream outputStream = fileSystem.create(path, true);
        SysdsProtos.Frame.Builder frameBuilder = SysdsProtos.Frame.newBuilder();
        try {
            Iterator<String[]> stringRowIterator = src.getStringRowIterator(lowerRowBound, upperRowBound);
            while (stringRowIterator.hasNext()) {
                String[] row = stringRowIterator.next();
                frameBuilder.addRowsBuilder().addAllColumnData(Arrays.asList(row));
            }
            frameBuilder.build().writeTo((OutputStream)outputStream);
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)outputStream);
        }
    }
}

