/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import org.apache.sysds.runtime.matrix.data.DnnParameters;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.NativeHelper;

public class LibMatrixDNNHelper {
    protected static CellIndex3 computeTensorIndexes(int j, int H, int W) {
        return LibMatrixDNNHelper.computeTensorIndexes(j, H, W, new CellIndex3());
    }

    protected static CellIndex3 computeTensorIndexes(int j, int N, int M, CellIndex3 ret) {
        int tmp = j / M;
        ret.ix1 = tmp / N;
        ret.ix2 = tmp % N;
        ret.ix3 = j % M;
        return ret;
    }

    protected static void singleThreadedMatMult(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, boolean recomputeNNZM1, boolean recomputeNNZM2, DnnParameters params) {
        if (!params.enableNative || m1.sparse || m2.sparse) {
            LibMatrixDNNHelper.prepNonZerosForMatrixMult(m1, recomputeNNZM1);
            LibMatrixDNNHelper.prepNonZerosForMatrixMult(m2, recomputeNNZM2);
            LibMatrixMult.matrixMult(m1, m2, ret, true);
        } else {
            ret.sparse = false;
            if (ret.getDenseBlock() == null) {
                ret.allocateDenseBlock();
            }
            NativeHelper.dmmdd(m1.getDenseBlockValues(), m2.getDenseBlockValues(), ret.getDenseBlockValues(), m1.rlen, m1.clen, m2.clen, 1);
        }
        ret.setNonZeros((long)ret.rlen * (long)ret.clen);
    }

    private static void prepNonZerosForMatrixMult(MatrixBlock mb, boolean update) {
        if (!update) {
            return;
        }
        if (!mb.isInSparseFormat()) {
            mb.setNonZeros((long)mb.getNumRows() * (long)mb.getNumColumns());
        } else {
            mb.recomputeNonZeros();
        }
    }

    protected static class CellIndex3 {
        public int ix1;
        public int ix2;
        public int ix3;

        protected CellIndex3() {
        }

        public String toString() {
            return "(" + this.ix1 + ", " + this.ix2 + ", " + this.ix3 + ")";
        }
    }
}

