/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt.impl.office;

import com.healthmarketscience.jackcess.crypt.impl.office.EncryptionHeader;
import com.healthmarketscience.jackcess.crypt.impl.office.EncryptionVerifier;
import com.healthmarketscience.jackcess.crypt.impl.office.StreamCipherProvider;
import com.healthmarketscience.jackcess.crypt.util.StreamCipherCompat;
import com.healthmarketscience.jackcess.crypt.util.StreamCipherFactory;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.PageChannel;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.KeyParameter;

public class RC4CryptoAPIProvider
extends StreamCipherProvider {
    private static final Set<EncryptionHeader.CryptoAlgorithm> VALID_CRYPTO_ALGOS = EnumSet.of(EncryptionHeader.CryptoAlgorithm.RC4);
    private static final Set<EncryptionHeader.HashAlgorithm> VALID_HASH_ALGOS = EnumSet.of(EncryptionHeader.HashAlgorithm.SHA1);
    private final EncryptionHeader _header;
    private final EncryptionVerifier _verifier;
    private final byte[] _baseHash;
    private final int _encKeyByteSize;

    public RC4CryptoAPIProvider(PageChannel channel, byte[] encodingKey, ByteBuffer encProvBuf, byte[] pwdBytes) {
        super(channel, encodingKey);
        this._header = EncryptionHeader.read(encProvBuf, VALID_CRYPTO_ALGOS, VALID_HASH_ALGOS);
        this._verifier = new EncryptionVerifier(encProvBuf, this._header.getCryptoAlgorithm());
        this._baseHash = RC4CryptoAPIProvider.hash(this.getDigest(), this._verifier.getSalt(), pwdBytes);
        this._encKeyByteSize = RC4CryptoAPIProvider.bits2bytes(this._header.getKeySize());
    }

    @Override
    public boolean canEncodePartialPage() {
        return true;
    }

    @Override
    protected Digest initDigest() {
        return new SHA1Digest();
    }

    @Override
    protected StreamCipherCompat initCipher() {
        return StreamCipherFactory.newRC4Engine();
    }

    @Override
    protected KeyParameter computeCipherParams(int pageNumber) {
        return this.computeEncryptionKey(this.getEncodingKey(pageNumber));
    }

    private KeyParameter computeEncryptionKey(byte[] blockBytes) {
        byte[] encKey = RC4CryptoAPIProvider.hash(this.getDigest(), this._baseHash, blockBytes, this._encKeyByteSize);
        if (this._header.getKeySize() == 40) {
            encKey = ByteUtil.copyOf(encKey, RC4CryptoAPIProvider.bits2bytes(128));
        }
        return new KeyParameter(encKey);
    }

    @Override
    protected boolean verifyPassword(byte[] pwdBytes) {
        StreamCipherCompat cipher = RC4CryptoAPIProvider.decryptInit(this.getStreamCipher(), (CipherParameters)this.computeEncryptionKey(this.int2bytes(0)));
        byte[] verifier = RC4CryptoAPIProvider.decryptBytes(cipher, this._verifier.getEncryptedVerifier());
        byte[] verifierHash = RC4CryptoAPIProvider.fixToLength(RC4CryptoAPIProvider.decryptBytes(cipher, this._verifier.getEncryptedVerifierHash()), this._verifier.getVerifierHashSize());
        byte[] testHash = RC4CryptoAPIProvider.fixToLength(RC4CryptoAPIProvider.hash(this.getDigest(), verifier), this._verifier.getVerifierHashSize());
        return Arrays.equals(verifierHash, testHash);
    }
}

