/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.hwp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.util.LittleEndian;

public class HwpStreamReader {
    private InputStream input;
    private byte[] buf;
    private byte[] skipBuffer = new byte[8192];

    public HwpStreamReader(InputStream inputStream) {
        this.input = inputStream;
        this.buf = new byte[4];
    }

    public short uint8() throws IOException {
        IOUtils.readFully(this.input, this.buf, 0, 1);
        return LittleEndian.getUByte(this.buf);
    }

    public int uint16() throws IOException {
        IOUtils.readFully(this.input, this.buf, 0, 2);
        return LittleEndian.getUShort(this.buf);
    }

    public int[] uint16(int i) throws IOException {
        if (i <= 0) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[i * 2];
        IOUtils.readFully(this.input, buf, 0, i * 2);
        int[] uints = new int[i];
        for (int ii = 0; ii < i; ++ii) {
            uints[ii] = LittleEndian.getUShort(buf, ii * 2);
        }
        return uints;
    }

    public long uint32() throws IOException {
        int read = org.apache.poi.util.IOUtils.readFully(this.input, this.buf, 0, 4);
        if (read == -1) {
            return -1L;
        }
        if (read < 4) {
            throw new EOFException();
        }
        return LittleEndian.getUInt(this.buf);
    }

    public void skipFully(long toSkip) throws IOException {
        long skipped = org.apache.tika.io.IOUtils.skip(this.input, toSkip, this.skipBuffer);
        if (skipped != toSkip) {
            throw new EOFException("Couldn't skip " + toSkip + ". Could only skip " + skipped);
        }
    }
}

