/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.formats.BioNLP2004NameSampleStreamFactory;
import opennlp.tools.formats.ChunkerSampleStreamFactory;
import opennlp.tools.formats.Conll02NameSampleStreamFactory;
import opennlp.tools.formats.Conll03NameSampleStreamFactory;
import opennlp.tools.formats.ConllXPOSSampleStreamFactory;
import opennlp.tools.formats.ConllXSentenceSampleStreamFactory;
import opennlp.tools.formats.ConllXTokenSampleStreamFactory;
import opennlp.tools.formats.DocumentSampleStreamFactory;
import opennlp.tools.formats.EvalitaNameSampleStreamFactory;
import opennlp.tools.formats.LanguageDetectorSampleStreamFactory;
import opennlp.tools.formats.LemmatizerSampleStreamFactory;
import opennlp.tools.formats.NameSampleDataStreamFactory;
import opennlp.tools.formats.ParseSampleStreamFactory;
import opennlp.tools.formats.SentenceSampleStreamFactory;
import opennlp.tools.formats.TokenSampleStreamFactory;
import opennlp.tools.formats.TwentyNewsgroupSampleStreamFactory;
import opennlp.tools.formats.WordTagSampleStreamFactory;
import opennlp.tools.formats.ad.ADChunkSampleStreamFactory;
import opennlp.tools.formats.ad.ADNameSampleStreamFactory;
import opennlp.tools.formats.ad.ADPOSSampleStreamFactory;
import opennlp.tools.formats.ad.ADSentenceSampleStreamFactory;
import opennlp.tools.formats.ad.ADTokenSampleStreamFactory;
import opennlp.tools.formats.brat.BratNameSampleStreamFactory;
import opennlp.tools.formats.conllu.ConlluLemmaSampleStreamFactory;
import opennlp.tools.formats.conllu.ConlluPOSSampleStreamFactory;
import opennlp.tools.formats.conllu.ConlluSentenceSampleStreamFactory;
import opennlp.tools.formats.conllu.ConlluTokenSampleStreamFactory;
import opennlp.tools.formats.convert.NameToSentenceSampleStreamFactory;
import opennlp.tools.formats.convert.NameToTokenSampleStreamFactory;
import opennlp.tools.formats.convert.POSToSentenceSampleStreamFactory;
import opennlp.tools.formats.convert.POSToTokenSampleStreamFactory;
import opennlp.tools.formats.convert.ParseToPOSSampleStreamFactory;
import opennlp.tools.formats.convert.ParseToSentenceSampleStreamFactory;
import opennlp.tools.formats.convert.ParseToTokenSampleStreamFactory;
import opennlp.tools.formats.frenchtreebank.ConstitParseSampleStreamFactory;
import opennlp.tools.formats.irishsentencebank.IrishSentenceBankSentenceStreamFactory;
import opennlp.tools.formats.irishsentencebank.IrishSentenceBankTokenSampleStreamFactory;
import opennlp.tools.formats.leipzig.LeipzigLanguageSampleStreamFactory;
import opennlp.tools.formats.letsmt.LetsmtSentenceStreamFactory;
import opennlp.tools.formats.masc.MascNamedEntitySampleStreamFactory;
import opennlp.tools.formats.masc.MascPOSSampleStreamFactory;
import opennlp.tools.formats.masc.MascSentenceSampleStreamFactory;
import opennlp.tools.formats.masc.MascTokenSampleStreamFactory;
import opennlp.tools.formats.moses.MosesSentenceSampleStreamFactory;
import opennlp.tools.formats.muc.Muc6NameSampleStreamFactory;
import opennlp.tools.formats.nkjp.NKJPSentenceSampleStreamFactory;
import opennlp.tools.formats.ontonotes.OntoNotesNameSampleStreamFactory;
import opennlp.tools.formats.ontonotes.OntoNotesPOSSampleStreamFactory;
import opennlp.tools.formats.ontonotes.OntoNotesParseSampleStreamFactory;

public final class StreamFactoryRegistry {
    private static final Map<Class<?>, Map<String, ObjectStreamFactory<?, ?>>> registry = new HashMap();
    public static final String DEFAULT_FORMAT = "opennlp";

    private StreamFactoryRegistry() {
    }

    public static <T, P> boolean registerFactory(Class<T> sampleClass, String formatName, ObjectStreamFactory<T, P> factory) {
        boolean result;
        Map<String, ObjectStreamFactory<?, ?>> formats = registry.get(sampleClass);
        if (null == formats) {
            formats = new HashMap();
        }
        if (!formats.containsKey(formatName)) {
            formats.put(formatName, factory);
            registry.put(sampleClass, formats);
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public static <T> void unregisterFactory(Class<T> sampleClass, String formatName) {
        Map<String, ObjectStreamFactory<?, ?>> formats = registry.get(sampleClass);
        if (null != formats) {
            formats.remove(formatName);
        }
    }

    public static <T, P> Map<String, ObjectStreamFactory<T, P>> getFactories(Class<T> sampleClass) {
        return registry.get(sampleClass);
    }

    public static <T, P> ObjectStreamFactory<T, P> getFactory(Class<T> sampleClass, String formatName) {
        ObjectStreamFactory<?, ?> factory;
        if (null == formatName) {
            formatName = DEFAULT_FORMAT;
        }
        ObjectStreamFactory<?, ?> objectStreamFactory = factory = registry.containsKey(sampleClass) ? registry.get(sampleClass).get(formatName) : null;
        if (factory != null) {
            return factory;
        }
        try {
            Class<?> factoryClazz = Class.forName(formatName);
            try {
                return (ObjectStreamFactory)factoryClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        ChunkerSampleStreamFactory.registerFactory();
        DocumentSampleStreamFactory.registerFactory();
        NameSampleDataStreamFactory.registerFactory();
        ParseSampleStreamFactory.registerFactory();
        SentenceSampleStreamFactory.registerFactory();
        TokenSampleStreamFactory.registerFactory();
        WordTagSampleStreamFactory.registerFactory();
        LemmatizerSampleStreamFactory.registerFactory();
        LanguageDetectorSampleStreamFactory.registerFactory();
        NameToSentenceSampleStreamFactory.registerFactory();
        NameToTokenSampleStreamFactory.registerFactory();
        POSToSentenceSampleStreamFactory.registerFactory();
        POSToTokenSampleStreamFactory.registerFactory();
        ParseToPOSSampleStreamFactory.registerFactory();
        ParseToSentenceSampleStreamFactory.registerFactory();
        ParseToTokenSampleStreamFactory.registerFactory();
        OntoNotesNameSampleStreamFactory.registerFactory();
        OntoNotesParseSampleStreamFactory.registerFactory();
        OntoNotesPOSSampleStreamFactory.registerFactory();
        BioNLP2004NameSampleStreamFactory.registerFactory();
        Conll02NameSampleStreamFactory.registerFactory();
        Conll03NameSampleStreamFactory.registerFactory();
        EvalitaNameSampleStreamFactory.registerFactory();
        ConllXPOSSampleStreamFactory.registerFactory();
        ConllXSentenceSampleStreamFactory.registerFactory();
        ConllXTokenSampleStreamFactory.registerFactory();
        ADChunkSampleStreamFactory.registerFactory();
        ADNameSampleStreamFactory.registerFactory();
        ADSentenceSampleStreamFactory.registerFactory();
        ADPOSSampleStreamFactory.registerFactory();
        ADTokenSampleStreamFactory.registerFactory();
        TwentyNewsgroupSampleStreamFactory.registerFactory();
        Muc6NameSampleStreamFactory.registerFactory();
        ConstitParseSampleStreamFactory.registerFactory();
        BratNameSampleStreamFactory.registerFactory();
        LetsmtSentenceStreamFactory.registerFactory();
        MosesSentenceSampleStreamFactory.registerFactory();
        ConlluTokenSampleStreamFactory.registerFactory();
        ConlluSentenceSampleStreamFactory.registerFactory();
        ConlluPOSSampleStreamFactory.registerFactory();
        ConlluLemmaSampleStreamFactory.registerFactory();
        IrishSentenceBankSentenceStreamFactory.registerFactory();
        IrishSentenceBankTokenSampleStreamFactory.registerFactory();
        LeipzigLanguageSampleStreamFactory.registerFactory();
        NKJPSentenceSampleStreamFactory.registerFactory();
        MascNamedEntitySampleStreamFactory.registerFactory();
        MascPOSSampleStreamFactory.registerFactory();
        MascSentenceSampleStreamFactory.registerFactory();
        MascTokenSampleStreamFactory.registerFactory();
    }
}

