/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize.lang.en;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenSampleStream
implements Iterator<TokenSample> {
    private static final Logger logger = LoggerFactory.getLogger(TokenSampleStream.class);
    private final BufferedReader in;
    private String line;
    private final Pattern alphaNumeric = Pattern.compile("[A-Za-z0-9]");
    private boolean evenq = true;

    public TokenSampleStream(InputStream is) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(is));
        this.line = this.in.readLine();
    }

    @Override
    public boolean hasNext() {
        return this.line != null;
    }

    @Override
    public TokenSample next() {
        String[] tokens = this.line.split("\\s+");
        if (tokens.length == 0) {
            this.evenq = true;
        }
        StringBuilder sb = new StringBuilder(this.line.length());
        ArrayList<Span> spans = new ArrayList<Span>();
        int length = 0;
        for (int ti = 0; ti < tokens.length; ++ti) {
            String token = tokens[ti];
            String lastToken = ti - 1 >= 0 ? tokens[ti - 1] : "";
            switch (token) {
                case "-LRB-": {
                    token = "(";
                    break;
                }
                case "-LCB-": {
                    token = "{";
                    break;
                }
                case "-RRB-": {
                    token = ")";
                    break;
                }
                case "-RCB-": {
                    token = "}";
                }
            }
            if (sb.length() != 0) {
                if (!this.alphaNumeric.matcher(token).find() || token.startsWith("'") || token.equalsIgnoreCase("n't")) {
                    if ((token.equals("``") || token.equals("--") || token.equals("$") || token.equals("(") || token.equals("&") || token.equals("#") || token.equals("\"") && this.evenq && ti != tokens.length - 1) && (!lastToken.equals("(") || !lastToken.equals("{"))) {
                        ++length;
                    }
                } else if (!(lastToken.equals("``") || lastToken.equals("\"") && !this.evenq || lastToken.equals("(") || lastToken.equals("{") || lastToken.equals("$") || lastToken.equals("#"))) {
                    ++length;
                }
            }
            if (token.equals("\"")) {
                boolean bl = this.evenq = ti == tokens.length - 1 || !this.evenq;
            }
            if (sb.length() < length) {
                sb.append(" ");
            }
            sb.append(token);
            spans.add(new Span(length, length + token.length()));
            length += token.length();
        }
        try {
            this.line = this.in.readLine();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), e);
            this.line = null;
        }
        return new TokenSample(sb.toString(), spans.toArray(new Span[0]));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static void usage() {
        logger.info("TokenSampleStream [-spans] < in");
        logger.info("Where in is a space delimited list of tokens.");
    }
}

