/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Comparator;
import java.util.Map;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeodeticCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultImageCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;

final class SubTypes
implements Comparator<Object> {
    private static final Class<?>[] TYPE_ORDER = new Class[]{ProjectedCRS.class, GeodeticCRS.class, VerticalCRS.class, TemporalCRS.class};
    static final Comparator<Object> BY_TYPE = new SubTypes();

    private SubTypes() {
    }

    private static int indexOf(Object object) {
        int i;
        for (i = 0; i < TYPE_ORDER.length && !TYPE_ORDER[i].isInstance(object); ++i) {
        }
        return i;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return SubTypes.indexOf(o1) - SubTypes.indexOf(o2);
    }

    static AbstractCRS castOrCopy(CoordinateReferenceSystem object) {
        if (object instanceof DerivedCRS) {
            return DefaultDerivedCRS.castOrCopy((DerivedCRS)object);
        }
        if (object instanceof ProjectedCRS) {
            return DefaultProjectedCRS.castOrCopy((ProjectedCRS)object);
        }
        if (object instanceof GeodeticCRS) {
            if (object instanceof GeographicCRS) {
                return DefaultGeographicCRS.castOrCopy((GeographicCRS)object);
            }
            if (object instanceof GeocentricCRS) {
                return DefaultGeocentricCRS.castOrCopy((GeocentricCRS)object);
            }
            if (object instanceof DefaultGeodeticCRS) {
                return (DefaultGeodeticCRS)object;
            }
            Map<String, ?> properties = IdentifiedObjects.getProperties(object, new String[0]);
            GeodeticDatum datum = ((GeodeticCRS)object).getDatum();
            CoordinateSystem cs = object.getCoordinateSystem();
            if (cs instanceof EllipsoidalCS) {
                return new DefaultGeographicCRS(properties, datum, (EllipsoidalCS)cs);
            }
            if (cs instanceof SphericalCS) {
                return new DefaultGeocentricCRS(properties, datum, (SphericalCS)cs);
            }
            if (cs instanceof CartesianCS) {
                return new DefaultGeocentricCRS(properties, datum, (CartesianCS)cs);
            }
        }
        if (object instanceof VerticalCRS) {
            return DefaultVerticalCRS.castOrCopy((VerticalCRS)object);
        }
        if (object instanceof TemporalCRS) {
            return DefaultTemporalCRS.castOrCopy((TemporalCRS)object);
        }
        if (object instanceof EngineeringCRS) {
            return DefaultEngineeringCRS.castOrCopy((EngineeringCRS)object);
        }
        if (object instanceof ImageCRS) {
            return DefaultImageCRS.castOrCopy((ImageCRS)object);
        }
        if (object instanceof CompoundCRS) {
            return DefaultCompoundCRS.castOrCopy((CompoundCRS)object);
        }
        if (object == null || object instanceof AbstractCRS) {
            return (AbstractCRS)object;
        }
        return new AbstractCRS(object);
    }
}

