/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.util;

import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.util.internal.Numerics;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;

enum AxesMapper {
    SAME,
    OPPOSITE,
    POLAR;

    private static final int EAST = 1;
    private static final int NORTH = 2;

    /*
     * Enabled aggressive block sorting
     */
    public static int[] indices(CoordinateSystem cs, CoordinateSystem subCS) {
        int[] indices = new int[subCS.getDimension()];
        long axesToSearch = Numerics.bitmask(indices.length) - 1L;
        long availableAxes = Numerics.bitmask(cs.getDimension()) - 1L;
        int directionUsed = 0;
        AxesMapper[] axesMapperArray = AxesMapper.values();
        int n = axesMapperArray.length;
        int n2 = 0;
        while (true) {
            int dimSubCS;
            long iterSubCS;
            AxesMapper comparisonMode;
            if (n2 < n) {
                comparisonMode = axesMapperArray[n2];
                iterSubCS = axesToSearch;
            } else {
                if (axesToSearch != 0L) return null;
                int[] nArray = indices;
                return nArray;
            }
            while (AxesMapper.hasMore(dimSubCS = Long.numberOfTrailingZeros(iterSubCS))) {
                long clearSubCS;
                block21: {
                    int dimCS;
                    clearSubCS = AxesMapper.clearMask(dimSubCS);
                    AxisDirection search = subCS.getAxis(dimSubCS).getDirection();
                    block0 : switch (comparisonMode) {
                        case OPPOSITE: {
                            AxisDirection axisDirection = search;
                            search = AxisDirections.opposite(search);
                            if (axisDirection != search && search != null) break;
                            break block21;
                        }
                        case POLAR: {
                            if (!CoordinateSystems.isAlongMeridian(search)) break;
                            switch (directionUsed) {
                                case 0: 
                                case 2: {
                                    search = AxisDirection.EAST;
                                    break block0;
                                }
                                case 1: {
                                    search = AxisDirection.NORTH;
                                    break block0;
                                }
                            }
                            return null;
                        }
                    }
                    long iterCS = availableAxes;
                    while (AxesMapper.hasMore(dimCS = Long.numberOfTrailingZeros(iterCS))) {
                        long clearCS = AxesMapper.clearMask(dimCS);
                        AxisDirection candidate = cs.getAxis(dimCS).getDirection();
                        if (comparisonMode == POLAR && CoordinateSystems.isAlongMeridian(candidate)) {
                            switch (directionUsed) {
                                case 0: 
                                case 2: {
                                    candidate = AxisDirection.EAST;
                                    break;
                                }
                                case 1: {
                                    candidate = AxisDirection.NORTH;
                                    break;
                                }
                                default: {
                                    return null;
                                }
                            }
                        }
                        if (search.equals(candidate)) {
                            if (search.equals(AxisDirection.EAST)) {
                                directionUsed |= 1;
                            }
                            if (search.equals(AxisDirection.NORTH)) {
                                directionUsed |= 2;
                            }
                            indices[dimSubCS] = dimCS;
                            availableAxes &= clearCS;
                            if ((axesToSearch &= clearSubCS) != 0L) break;
                            return indices;
                        }
                        iterCS &= clearCS;
                    }
                }
                iterSubCS &= clearSubCS;
            }
            ++n2;
        }
    }

    private static boolean hasMore(int numBits) {
        return (numBits & 0xFFFFFFC0) == 0;
    }

    private static long clearMask(int dim) {
        return 1L << dim ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

