/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.TableConfig;

public class CoordSysEvaluator {
    public static void findCoords(TableConfig nt, NetcdfDataset ds, Predicate p) {
        nt.lat = CoordSysEvaluator.findCoordShortNameByType(ds, AxisType.Lat, p);
        nt.lon = CoordSysEvaluator.findCoordShortNameByType(ds, AxisType.Lon, p);
        nt.time = CoordSysEvaluator.findCoordShortNameByType(ds, AxisType.Lat, p);
        nt.elev = CoordSysEvaluator.findCoordShortNameByType(ds, AxisType.Height, p);
        if (nt.elev == null) {
            nt.elev = CoordSysEvaluator.findCoordShortNameByType(ds, AxisType.Pressure, p);
        }
    }

    public static String findCoordNameByType(NetcdfDataset ds, AxisType atype) {
        CoordinateAxis coordAxis = CoordSysEvaluator.findCoordByType(ds, atype);
        return coordAxis == null ? null : coordAxis.getFullName();
    }

    public static String findCoordShortNameByType(NetcdfDataset ds, AxisType atype) {
        CoordinateAxis coordAxis = CoordSysEvaluator.findCoordByType(ds, atype);
        return coordAxis == null ? null : coordAxis.getShortName();
    }

    public static String findCoordShortNameByType(NetcdfDataset ds, AxisType atype, Predicate p) {
        CoordinateAxis coordAxis = CoordSysEvaluator.findCoordByType(ds, atype, p);
        return coordAxis == null ? null : coordAxis.getShortName();
    }

    public static CoordinateAxis findCoordByType(NetcdfDataset ds, AxisType atype) {
        return CoordSysEvaluator.findCoordByType(ds, atype, null);
    }

    public static CoordinateAxis findCoordByType(NetcdfDataset ds, AxisType atype, Predicate p) {
        CoordinateSystem use = CoordSysEvaluator.findBestCoordinateSystem(ds);
        if (use == null) {
            return null;
        }
        CoordinateAxis result = CoordSysEvaluator.findCoordByType(use.getCoordinateAxes(), atype, p);
        if (result != null) {
            return result;
        }
        return CoordSysEvaluator.findCoordByType(ds.getCoordinateAxes(), atype, p);
    }

    public static CoordinateAxis findCoordByType(List<CoordinateAxis> axes, AxisType atype, Predicate p) {
        for (CoordinateAxis axis : axes) {
            Attribute att;
            if (axis.getAxisType() != atype || (att = axis.findAttribute("axis")) == null || !att.getStringValue().equals(atype.getCFAxisName()) || p != null && !p.match(axis)) continue;
            return axis;
        }
        for (CoordinateAxis axis : axes) {
            if (axis.getAxisType() != atype || p != null && !p.match(axis)) continue;
            return axis;
        }
        return null;
    }

    public static Dimension findDimensionByType(NetcdfDataset ds, AxisType atype) {
        CoordinateAxis axis = CoordSysEvaluator.findCoordByType(ds, atype);
        if (axis == null) {
            return null;
        }
        if (axis.isScalar()) {
            return null;
        }
        return axis.getDimension(0);
    }

    private static CoordinateSystem findBestCoordinateSystem(NetcdfDataset ds) {
        CoordinateSystem use = null;
        for (CoordinateSystem cs : ds.getCoordinateSystems()) {
            if (use == null) {
                use = cs;
                continue;
            }
            if (cs.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
            use = cs;
        }
        return use;
    }

    public static interface Predicate {
        public boolean match(CoordinateAxis var1);
    }
}

