import SaslMechanismBase, { SaslMechanismBaseOptions } from './sasl-mechanism-base.js';
export type SaslMechanismPlainOptions = SaslMechanismBaseOptions & {};
export default class SaslMechanismPlain extends SaslMechanismBase {
    /**
     * Creates a new instance of SaslMechanismPlain.
     * @param {Object} [options] The mechanism options.
     * @param {String} [options.authzid] The identity of the client.
     * @param {String} [options.username] The identity of user with access to server.
     * @param {String} [options.password] The password of user with access to server.
     * @constructor
     */
    constructor(options: SaslMechanismPlainOptions);
    /**
     * Returns the name of the mechanism
     */
    get name(): string;
    /**
     * Evaluates the challenge from the server and returns appropriate response.
     * @param {String} challenge Challenge string presented by the server.
     * @return {Object} A Promise that resolves to a valid sasl response object.
     */
    evaluateChallenge(challenge: string): Promise<{
        sasl: string;
    }>;
    /**
     * Generates a base64 encoded sasl argument based on the given parameters.
     * @param {String} authzid Identitiy of the client.
     * @param {String} username The identity of user with access to server.
     * @param {String} password The password of user with access to server.
     */
    _saslArgument(authzid: string, username: String, password: string): string;
    /**
     * Checks challenge to see if we have the initial sasl response from the server.
     * @param {String} challenge The challenge string from the server.
     * @return {Boolean}
     */
    _hasInitialResponse(challenge: string): boolean;
}
