/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.util.Locale;
import org.apache.taglibs.standard.resources.Resources;

public class LocaleUtil {
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';

    public static Locale parseLocaleAttributeValue(Object stringOrLocale) {
        if (stringOrLocale instanceof Locale) {
            return (Locale)stringOrLocale;
        }
        if (stringOrLocale instanceof String) {
            String string = (String)stringOrLocale;
            if (string.length() == 0) {
                return null;
            }
            return LocaleUtil.parseLocale(string.trim());
        }
        return null;
    }

    public static Locale parseLocale(String locale) {
        return LocaleUtil.parseLocale(locale, null);
    }

    public static Locale parseLocale(String locale, String variant) {
        String country;
        String language;
        int index = locale.indexOf(45);
        if (index > -1 || (index = locale.indexOf(95)) > -1) {
            if (index == 0) {
                throw new IllegalArgumentException(Resources.getMessage("LOCALE_NO_LANGUAGE"));
            }
            if (index == locale.length() - 1) {
                throw new IllegalArgumentException(Resources.getMessage("LOCALE_EMPTY_COUNTRY"));
            }
            language = locale.substring(0, index);
            country = locale.substring(index + 1);
        } else {
            language = locale;
            country = "";
        }
        if (variant != null) {
            return new Locale(language, country, variant);
        }
        return new Locale(language, country);
    }
}

