/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Producer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AbstractInjectable;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;

public class InjectableMethod<T>
extends AbstractInjectable<T> {
    protected Method method;
    protected Object ownerInstance;
    private boolean disposable;
    private Object producerMethodInstance;
    private Map<Bean<?>, Object> dependentParameters = new HashMap();
    private Set<InjectionPoint> injectionPoints;

    public InjectableMethod(Method m, Object instance, Producer<T> owner, CreationalContextImpl<T> creationalContext) {
        this(m, instance, owner, creationalContext, new HashSet<InjectionPoint>(InjectableMethod.createInjectionPoints(owner, m)));
    }

    public InjectableMethod(Method m, Object instance, Producer<T> owner, CreationalContextImpl<T> creationalContext, Set<InjectionPoint> ips) {
        super(owner, creationalContext);
        this.method = m;
        this.ownerInstance = instance;
        this.injectionPoints = ips;
    }

    public T doInjection() {
        Object owner = this.ownerInstance;
        if (owner instanceof OwbNormalScopeProxy) {
            owner = NormalScopeProxyFactory.unwrapInstance(owner);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        block5: for (int i = 0; i < this.injectionPoints.size(); ++i) {
            for (InjectionPoint point : this.injectionPoints) {
                AnnotatedParameter parameter = (AnnotatedParameter)point.getAnnotated();
                if (parameter.getPosition() != i) continue;
                if (point.isDelegate()) {
                    list.add(this.creationalContext.getDelegate());
                    continue block5;
                }
                boolean injectionPoint = false;
                if (this.getBean() instanceof ProducerMethodBean && parameter.getBaseType().equals(InjectionPoint.class)) {
                    BeanManagerImpl manager = this.getWebBeansContext().getBeanManagerImpl();
                    Object reference = manager.getInjectableReference(point, this.creationalContext);
                    list.add(reference);
                    injectionPoint = true;
                }
                if (injectionPoint) continue block5;
                if (this.isDisposable() && parameter.getAnnotation(Disposes.class) != null) {
                    list.add(this.producerMethodInstance);
                    continue block5;
                }
                Object instance = this.inject(point);
                InjectionResolver injectionResolver = this.getWebBeansContext().getBeanManagerImpl().getInjectionResolver();
                Bean<?> injectedBean = injectionResolver.getInjectionPointBean(point);
                if (injectedBean.getScope() == Dependent.class) {
                    this.dependentParameters.put(injectedBean, instance);
                }
                list.add(instance);
                continue block5;
            }
        }
        try {
            if (!this.method.isAccessible()) {
                this.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.method, true);
            }
            Object i = this.method.invoke(owner, list.toArray(new Object[list.size()]));
            return (T)i;
        }
        catch (Exception e) {
            throw new WebBeansException(e);
        }
        finally {
            this.transientCreationalContext.release();
        }
    }

    public Map<Bean<?>, Object> getDependentBeanParameters() {
        return this.dependentParameters;
    }

    private boolean isDisposable() {
        return this.disposable;
    }

    public void setDisposable(boolean disposable) {
        this.disposable = disposable;
    }

    public void setProducerMethodInstance(Object instance) {
        this.producerMethodInstance = instance;
    }
}

