/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.OverridesAttribute;
import jakarta.validation.ValidationException;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.ConstraintCached;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.util.AnnotationProxyBuilder;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class AnnotationsManager {
    private static final Set<ConstraintAnnotationAttributes> CONSTRAINT_ATTRIBUTES = Collections.unmodifiableSet(EnumSet.complementOf(EnumSet.of(ConstraintAnnotationAttributes.VALUE)));
    private static final Set<Class<? extends Annotation>> VALIDATED_CONSTRAINT_TYPES = new HashSet<Class<? extends Annotation>>();
    private final ApacheValidatorFactory validatorFactory;
    private final ConcurrentMap<Class<?>, Composition> compositions;
    private final ConcurrentMap<Class<?>, Method[]> constraintAttributes;

    public static Map<String, Object> readAttributes(Annotation a) {
        Lazy<Map> result = new Lazy<Map>(LinkedHashMap::new);
        Stream.of(Reflection.getDeclaredMethods(a.annotationType())).filter(m -> m.getParameterCount() == 0).forEach(m -> {
            Reflection.makeAccessible(m);
            try {
                ((Map)result.get()).put(m.getName(), m.invoke((Object)a, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Exceptions.raise(ValidationException::new, e, "Caught exception reading attributes of %s", a);
            }
        });
        return result.optional().map(Collections::unmodifiableMap).orElseGet(Collections::emptyMap);
    }

    public static boolean isAnnotationDirectlyPresent(AnnotatedElement e, Class<? extends Annotation> t) {
        return AnnotationsManager.substitute(e).filter(s -> s.isAnnotationPresent(t)).isPresent();
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement e, Class<T> annotationClass) {
        return (T)((Annotation)AnnotationsManager.substitute(e).map(s -> s.getAnnotation(annotationClass)).orElse(null));
    }

    public static <T extends Annotation> T[] getDeclaredAnnotationsByType(AnnotatedElement e, Class<T> annotationClass) {
        return AnnotationsManager.substitute(e).map(s -> s.getDeclaredAnnotationsByType(annotationClass)).orElse(ObjectUtils.EMPTY_ANNOTATION_ARRAY);
    }

    public static Annotation[] getDeclaredConstraints(Meta<?> meta) {
        return AnnotationsManager.getDeclaredConstraints(meta.getHost());
    }

    private static Annotation[] getDeclaredConstraints(AnnotatedElement e) {
        Annotation[] declaredAnnotations = AnnotationsManager.substitute(e).map(AnnotatedElement::getDeclaredAnnotations).orElse(ObjectUtils.EMPTY_ANNOTATION_ARRAY);
        if (declaredAnnotations.length == 0) {
            return declaredAnnotations;
        }
        HashMap<Class<? extends Annotation>, Annotation[]> repeated = new HashMap<Class<? extends Annotation>, Annotation[]>();
        for (Annotation a2 : declaredAnnotations) {
            Class<? extends Annotation> annotationType = a2.annotationType();
            ConstraintAnnotationAttributes.Worker<? extends Annotation> w = ConstraintAnnotationAttributes.VALUE.analyze(annotationType);
            if (!w.isValid() || !((Class)w.getSpecificType()).getComponentType().isAnnotationPresent(Constraint.class)) continue;
            repeated.put(annotationType, (Annotation[])w.read(a2));
        }
        Stream<Annotation> constraints = Stream.of(declaredAnnotations).filter(a -> a.annotationType().isAnnotationPresent(Constraint.class));
        if (!repeated.isEmpty()) {
            constraints = constraints.peek(c -> Exceptions.raiseIf(Optional.of(c.annotationType()).map(t -> t.getAnnotation(Repeatable.class)).map(Repeatable::value).filter(repeated::containsKey).isPresent(), ConstraintDeclarationException::new, "Simultaneous declaration of repeatable constraint and associated container on %s", e));
            constraints = Stream.concat(constraints, repeated.values().stream().flatMap(Stream::of));
        }
        return (Annotation[])constraints.toArray(Annotation[]::new);
    }

    private static Optional<AnnotatedElement> substitute(AnnotatedElement e) {
        Constructor ctor;
        Class dc;
        Parameter p;
        if (e instanceof Parameter && (p = (Parameter)e).getDeclaringExecutable() instanceof Constructor && (dc = (ctor = (Constructor)p.getDeclaringExecutable()).getDeclaringClass()).getDeclaringClass() != null && !Modifier.isStatic(dc.getModifiers())) {
            Annotation[][] parameterAnnotations = ctor.getParameterAnnotations();
            if (parameterAnnotations.length == ctor.getParameterCount() - 1) {
                Object[] parameters = ctor.getParameters();
                int idx = ObjectUtils.indexOf(parameters, p);
                if (idx == 0) {
                    return Optional.empty();
                }
                return Optional.of(parameters[idx - 1]);
            }
            Validate.validState(parameterAnnotations.length == ctor.getParameterCount(), "Cannot make sense of parameter annotations of %s", ctor);
        }
        return Optional.of(e);
    }

    public AnnotationsManager(ApacheValidatorFactory validatorFactory) {
        this.validatorFactory = Validate.notNull(validatorFactory);
        this.compositions = new ConcurrentHashMap();
        this.constraintAttributes = new ConcurrentHashMap();
    }

    public void validateConstraintDefinition(Class<? extends Annotation> type) {
        if (VALIDATED_CONSTRAINT_TYPES.contains(type)) {
            return;
        }
        Exceptions.raiseUnless(type.isAnnotationPresent(Constraint.class), ConstraintDefinitionException::new, "%s is not a validation constraint", type);
        Set<ValidationTarget> supportedTargets = this.supportedTargets(type);
        Map attributes = Stream.of(Reflection.getDeclaredMethods(type)).filter(m -> m.getParameterCount() == 0).collect(Collectors.toMap(Method::getName, Function.identity()));
        if (supportedTargets.size() > 1 && !attributes.containsKey(ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO.getAttributeName())) {
            Exceptions.raise(ConstraintDefinitionException::new, "Constraint %s is both generic and cross-parameter but lacks %s attribute", new Object[]{type.getName(), ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO});
        }
        for (ConstraintAnnotationAttributes attr : CONSTRAINT_ATTRIBUTES) {
            if (attributes.containsKey(attr.getAttributeName())) {
                Exceptions.raiseUnless(attr.analyze(type).isValid(), ConstraintDefinitionException::new, "%s declared invalid type for attribute %s", new Object[]{type, attr});
                if (!attr.isValidDefaultValue(((Method)attributes.get(attr.getAttributeName())).getDefaultValue())) {
                    Exceptions.raise(ConstraintDefinitionException::new, "%s declares invalid default value for attribute %s", new Object[]{type, attr});
                }
                if (attr == ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO && supportedTargets.size() == 1) {
                    Exceptions.raise(ConstraintDefinitionException::new, "Pure %s constraint %s should not declare attribute %s", new Object[]{supportedTargets.iterator().next(), type, attr});
                }
            } else if (attr.isMandatory()) {
                Exceptions.raise(ConstraintDefinitionException::new, "%s does not declare mandatory attribute %s", new Object[]{type, attr});
            }
            attributes.remove(attr.getAttributeName());
        }
        attributes.keySet().forEach(k -> Exceptions.raiseIf(k.startsWith("valid"), ConstraintDefinitionException::new, "Invalid constraint attribute %s", k));
        VALIDATED_CONSTRAINT_TYPES.add(type);
    }

    public Annotation[] getComposingConstraints(Annotation a) {
        return this.getComposition(a.annotationType()).getComponents(a);
    }

    public boolean isComposed(Annotation a) {
        return this.getComposition(a.annotationType()).isComposed();
    }

    public <A extends Annotation> Set<ValidationTarget> supportedTargets(Class<A> constraintType) {
        Set<ConstraintCached.ConstraintValidatorInfo<A>> constraintValidatorInfo = this.validatorFactory.getConstraintsCache().getConstraintValidatorInfo(constraintType);
        Stream<Set> s = constraintValidatorInfo.isEmpty() ? Stream.of((AnnotationsManager)this.new Composition(constraintType).components).map(Annotation::annotationType).map(this::supportedTargets) : constraintValidatorInfo.stream().map(ConstraintCached.ConstraintValidatorInfo::getSupportedTargets);
        return s.flatMap(Collection::stream).collect(Collectors.toCollection(() -> EnumSet.noneOf(ValidationTarget.class)));
    }

    public <A extends Annotation> AnnotationProxyBuilder<A> buildProxyFor(Class<A> type) {
        return new AnnotationProxyBuilder<Class<A>>(type, this.constraintAttributes);
    }

    public <A extends Annotation> AnnotationProxyBuilder<A> buildProxyFor(A instance) {
        return new AnnotationProxyBuilder<A>(instance, this.constraintAttributes);
    }

    private Composition getComposition(Class<? extends Annotation> annotationType) {
        return this.compositions.computeIfAbsent(annotationType, ct -> {
            Set<ValidationTarget> composedTargets = this.supportedTargets(annotationType);
            Composition result = new Composition(annotationType);
            Stream.of(result.components).map(Annotation::annotationType).forEach(at -> {
                Set<ValidationTarget> composingTargets = this.supportedTargets((Class)at);
                if (Collections.disjoint(composingTargets, composedTargets)) {
                    Exceptions.raise(ConstraintDefinitionException::new, "Attempt to compose %s of %s but validator types are incompatible", annotationType.getName(), at.getName());
                }
            });
            return result;
        });
    }

    private class Composition {
        final Lazy<Map<OverriddenAnnotationSpecifier, Map<String, String>>> overrides = new Lazy<Map>(HashMap::new);
        final Annotation[] components;

        <A extends Annotation> Optional<ConstraintAnnotationAttributes.Worker<A>> validWorker(ConstraintAnnotationAttributes attr, Class<A> type) {
            return Optional.of(type).map(attr::analyze).filter(ConstraintAnnotationAttributes.Worker::isValid);
        }

        Composition(Class<? extends Annotation> annotationType) {
            this.components = AnnotationsManager.getDeclaredConstraints(annotationType);
            if (!this.isComposed()) {
                return;
            }
            HashMap<Class, AtomicInteger> constraintCounts = new HashMap<Class, AtomicInteger>();
            for (Annotation a : this.components) {
                constraintCounts.computeIfAbsent(a.annotationType(), k -> new AtomicInteger()).incrementAndGet();
            }
            for (Method m : Reflection.getDeclaredMethods(annotationType)) {
                String from = m.getName();
                for (OverridesAttribute overridesAttribute : (OverridesAttribute[])m.getDeclaredAnnotationsByType(OverridesAttribute.class)) {
                    String to = Optional.of(overridesAttribute.name()).filter(StringUtils::isNotBlank).orElse(from);
                    OverriddenAnnotationSpecifier spec = new OverriddenAnnotationSpecifier(overridesAttribute);
                    int count = ((AtomicInteger)constraintCounts.get(spec.annotationType)).get();
                    if (spec.impliesSingleComposingConstraint) {
                        Exceptions.raiseUnless(count == 1, ConstraintDefinitionException::new, "Expected a single composing %s constraint", spec.annotationType);
                    } else if (count <= spec.constraintIndex) {
                        Exceptions.raise(ConstraintDefinitionException::new, "Expected at least %s composing %s constraints", spec.constraintIndex + 1, spec.annotationType);
                    }
                    Map attributeMapping = this.overrides.get().computeIfAbsent(spec, k -> new HashMap());
                    if (attributeMapping.containsKey(to)) {
                        Exceptions.raise(ConstraintDefinitionException::new, "Attempt to override %s#%s() index %d from multiple sources", overridesAttribute.constraint(), to, overridesAttribute.constraintIndex());
                    }
                    attributeMapping.put(to, from);
                }
            }
        }

        boolean isComposed() {
            return this.components.length > 0;
        }

        Annotation[] getComponents(Annotation source) {
            Class[] groups = (Class[])ConstraintAnnotationAttributes.GROUPS.analyze(source.annotationType()).read(source);
            Class[] payload = (Class[])ConstraintAnnotationAttributes.PAYLOAD.analyze(source.annotationType()).read(source);
            Optional<ConstraintTarget> constraintTarget = this.validWorker(ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO, source.annotationType()).map(w -> (ConstraintTarget)w.read(source));
            HashMap constraintCounts = new HashMap();
            return (Annotation[])Stream.of(this.components).map(c -> {
                int index = constraintCounts.computeIfAbsent(c.annotationType(), k -> new AtomicInteger()).getAndIncrement();
                AnnotationProxyBuilder<Annotation> proxyBuilder = AnnotationsManager.this.buildProxyFor(c);
                proxyBuilder.setGroups(groups);
                proxyBuilder.setPayload(payload);
                if (constraintTarget.isPresent() && this.validWorker(ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO, c.annotationType()).isPresent()) {
                    proxyBuilder.setValidationAppliesTo((ConstraintTarget)constraintTarget.get());
                }
                this.overrides.optional().map(o -> (Map)o.get(new OverriddenAnnotationSpecifier(c.annotationType(), index))).ifPresent(m -> {
                    Map<String, Object> sourceAttributes = AnnotationsManager.readAttributes(source);
                    m.forEach((k, v) -> proxyBuilder.setValue((String)k, sourceAttributes.get(v)));
                });
                return proxyBuilder.isChanged() ? proxyBuilder.createAnnotation() : c;
            }).toArray(Annotation[]::new);
        }
    }

    private static final class OverriddenAnnotationSpecifier {
        final Class<? extends Annotation> annotationType;
        final boolean impliesSingleComposingConstraint;
        final int constraintIndex;

        OverriddenAnnotationSpecifier(OverridesAttribute annotation) {
            this(annotation.constraint(), annotation.constraintIndex());
        }

        OverriddenAnnotationSpecifier(Class<? extends Annotation> annotationType, int constraintIndex) {
            this.annotationType = annotationType;
            this.impliesSingleComposingConstraint = constraintIndex < 0;
            this.constraintIndex = Math.max(constraintIndex, 0);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            OverriddenAnnotationSpecifier other = (OverriddenAnnotationSpecifier)obj;
            return Objects.equals(this.annotationType, other.annotationType) && this.constraintIndex == other.constraintIndex;
        }

        public int hashCode() {
            return Objects.hash(this.annotationType, this.constraintIndex);
        }
    }
}

