/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import java.util.Collection;
import junit.framework.TestCase;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.dynamic.entity.impl.DynamicGroupImpl;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.SecuritySet;

public class SecuritySetTest
extends TestCase {
    public SecuritySetTest(String name) {
        super(name);
    }

    public void testNull() throws Exception {
        GroupSet securitySet = new GroupSet();
        SecuritySetTest.assertFalse((boolean)securitySet.contains(null));
    }

    public void testContainsName() {
        GroupSet securitySet = new GroupSet();
        SecuritySetTest.assertFalse((boolean)securitySet.containsName(null));
        DynamicGroupImpl g = new DynamicGroupImpl();
        g.setName("BOB");
        securitySet.add((SecurityEntity)g);
        SecuritySetTest.assertTrue((boolean)securitySet.containsName("bob"));
        SecuritySetTest.assertTrue((boolean)securitySet.containsName("BOB"));
    }

    public void testRemoveAll() {
        GroupSet securitySet = new GroupSet();
        SecuritySetTest.assertFalse((boolean)securitySet.containsName(null));
        DynamicGroupImpl g = new DynamicGroupImpl();
        g.setName("BOB");
        g.setId((Object)"BOB");
        securitySet.add((SecurityEntity)g);
        GroupSet securitySet2 = new GroupSet();
        SecuritySetTest.assertFalse((boolean)securitySet.containsName(null));
        g = new DynamicGroupImpl();
        g.setName("BOB");
        g.setId((Object)"BOB");
        securitySet2.add((SecurityEntity)g);
        securitySet.removeAll((Collection)securitySet2);
        SecuritySetTest.assertEquals((int)0, (int)securitySet.size());
    }

    public void testToArray() throws Exception {
        SecuritySet<Group> securitySet = this.getTestData();
        Object[] array = securitySet.toArray();
        SecuritySetTest.assertEquals((int)2, (int)array.length);
        Object[] array2 = new Object[2];
        array2[0] = "hi";
        Object[] array3 = securitySet.toArray(array2);
        SecuritySetTest.assertEquals((int)2, (int)array3.length);
    }

    public void testAdd() throws Exception {
        GroupSet securitySet = (GroupSet)this.getTestData();
        DynamicGroupImpl g = new DynamicGroupImpl();
        g.setName("Michael");
        g.setId((Object)"Michael");
        SecuritySetTest.assertTrue((boolean)securitySet.add((SecurityEntity)g));
    }

    private SecuritySet<Group> getTestData() {
        GroupSet securitySet = new GroupSet();
        SecuritySetTest.assertFalse((boolean)securitySet.containsName(null));
        DynamicGroupImpl g = new DynamicGroupImpl();
        g.setName("JOE");
        g.setId((Object)"JOE");
        DynamicGroupImpl g2 = new DynamicGroupImpl();
        g2.setName("RICK");
        g2.setId((Object)"RICK");
        securitySet.add((SecurityEntity)g);
        securitySet.add((SecurityEntity)g2);
        return securitySet;
    }
}

