/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors;

import org.apache.uima.taeconfigurator.Messages;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.xml.XMLEditor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class MultiPageEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart activeEditorPart;
    Action autoJCasAction;
    Action limitJCasGenToProject;
    Action qualifiedTypesAction;
    Action runJCasGenAction;

    public MultiPageEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(MultiPageEditorPart editor, String actionID) {
        ITextEditor txtEditor = ((MultiPageEditor)editor).getSourcePageEditor();
        return txtEditor == null ? null : txtEditor.getAction(actionID);
    }

    protected IAction getAction1(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActiveEditor(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        if (null == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            MultiPageEditorPart editor = (MultiPageEditorPart)part;
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(editor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(editor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.updateActionBars();
        }
    }

    public void setActivePage(IEditorPart part) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            ITextEditor textEditor = part instanceof XMLEditor ? (ITextEditor)part : null;
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction1(textEditor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction1(textEditor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction1(textEditor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction1(textEditor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction1(textEditor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction1(textEditor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction1(textEditor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction1(textEditor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction1(textEditor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.updateActionBars();
        }
    }

    private void createActions() {
        this.autoJCasAction = new Action(){

            public void run() {
                TAEConfiguratorPlugin plugin = TAEConfiguratorPlugin.getDefault();
                Preferences prefs = plugin.getPluginPreferences();
                boolean bAutoJCasGen = !prefs.getBoolean("org.apache.uima.cde.autojcasgen");
                MultiPageEditorContributor.this.autoJCasAction.setChecked(bAutoJCasGen);
                prefs.setValue("org.apache.uima.cde.autojcasgen", bAutoJCasGen);
            }
        };
        this.limitJCasGenToProject = new Action(){

            public void run() {
                TAEConfiguratorPlugin plugin = TAEConfiguratorPlugin.getDefault();
                Preferences prefs = plugin.getPluginPreferences();
                boolean bJCasLimit = !prefs.getBoolean("org.apache.uima.cde.jcasgen.limittoprojectscope");
                MultiPageEditorContributor.this.limitJCasGenToProject.setChecked(bJCasLimit);
                prefs.setValue("org.apache.uima.cde.jcasgen.limittoprojectscope", bJCasLimit);
            }
        };
        this.runJCasGenAction = new Action(){

            public void run() {
                ((MultiPageEditor)MultiPageEditorContributor.this.activeEditorPart).doJCasGenChkSrc(null);
            }
        };
        this.qualifiedTypesAction = new Action(){

            public void run() {
                TAEConfiguratorPlugin plugin = TAEConfiguratorPlugin.getDefault();
                Preferences prefs = plugin.getPluginPreferences();
                boolean bFullyQualifiedTypeNames = !prefs.getBoolean("org.apache.uima.cde.qualifiedtypes");
                MultiPageEditorContributor.this.qualifiedTypesAction.setChecked(bFullyQualifiedTypeNames);
                prefs.setValue("org.apache.uima.cde.qualifiedtypes", bFullyQualifiedTypeNames);
                IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
                for (int i = 0; i < pages.length; ++i) {
                    IEditorPart[] editors = pages[i].getEditors();
                    for (int j = 0; j < editors.length; ++j) {
                        if (editors[j] == null || !(editors[j] instanceof MultiPageEditor)) continue;
                        ((MultiPageEditor)editors[j]).markAllPagesStale();
                    }
                }
            }
        };
        this.autoJCasAction.setText(Messages.getString("MultiPageEditorContributor.autoGenJCas"));
        this.autoJCasAction.setChecked(MultiPageEditorContributor.getAutoJCasGen());
        this.limitJCasGenToProject.setText(Messages.getString("MultiPageEditorContributor.limitJCasGenToProjectScope"));
        this.limitJCasGenToProject.setChecked(MultiPageEditorContributor.getLimitJCasGenToProjectScope());
        this.qualifiedTypesAction.setText(Messages.getString("MultiPageEditorContributor.showFullNames"));
        this.qualifiedTypesAction.setChecked(MultiPageEditorContributor.getUseQualifiedTypes());
        this.runJCasGenAction.setText("Run JCasGen");
    }

    public void contributeToMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("&UIMA");
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.runJCasGenAction);
        MenuManager settingsMenu = new MenuManager("Settings");
        menu.add((IContributionItem)settingsMenu);
        settingsMenu.add((IAction)this.autoJCasAction);
        settingsMenu.add((IAction)this.qualifiedTypesAction);
        settingsMenu.add((IAction)this.limitJCasGenToProject);
    }

    public static boolean getAutoJCasGen() {
        return MultiPageEditorContributor.getUimaPrefBoolean("org.apache.uima.cde.autojcasgen", false);
    }

    public static boolean getUseQualifiedTypes() {
        return MultiPageEditorContributor.getUimaPrefBoolean("org.apache.uima.cde.qualifiedtypes", true);
    }

    public static boolean getLimitJCasGenToProjectScope() {
        return MultiPageEditorContributor.getUimaPrefBoolean("org.apache.uima.cde.jcasgen.limittoprojectscope", false);
    }

    public static int getXMLindent() {
        return MultiPageEditorContributor.getUimaPrefInt("org.apache.uima.cde.xmlIndentAmount", 2);
    }

    public static String getCDEVnsHost() {
        return MultiPageEditorContributor.getUimaPrefString("org.apache.uima.cde.vnsHost", "localhost");
    }

    public static String getCDEVnsPort() {
        return MultiPageEditorContributor.getUimaPrefString("org.apache.uima.cde.vnsPort", "9000");
    }

    public static void setVnsHost(String v) {
        System.setProperty("VNS_HOST", v);
    }

    public static void setVnsPort(String v) {
        System.setProperty("VNS_PORT", v);
    }

    public static void setVnsHost() {
        MultiPageEditorContributor.setVnsHost(MultiPageEditorContributor.getCDEVnsHost());
    }

    public static void setVnsPort() {
        MultiPageEditorContributor.setVnsPort(MultiPageEditorContributor.getCDEVnsPort());
    }

    private static String getUimaPrefString(String key, String defaultValue) {
        TAEConfiguratorPlugin plugin = TAEConfiguratorPlugin.getDefault();
        Preferences prefs = plugin.getPluginPreferences();
        boolean isDefault = prefs.isDefault(key);
        if (isDefault) {
            prefs.setDefault(key, defaultValue);
        }
        return prefs.getString(key);
    }

    private static boolean getUimaPrefBoolean(String key, boolean defaultValue) {
        TAEConfiguratorPlugin plugin = TAEConfiguratorPlugin.getDefault();
        Preferences prefs = plugin.getPluginPreferences();
        boolean isDefault = prefs.isDefault(key);
        if (isDefault) {
            prefs.setDefault(key, defaultValue);
        }
        return prefs.getBoolean(key);
    }

    private static int getUimaPrefInt(String key, int defaultValue) {
        TAEConfiguratorPlugin plugin = TAEConfiguratorPlugin.getDefault();
        Preferences prefs = plugin.getPluginPreferences();
        boolean isDefault = prefs.isDefault(key);
        if (isDefault) {
            prefs.setDefault(key, defaultValue);
        }
        return prefs.getInt(key);
    }
}

