/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.impl.ResourceManagerConfiguration_impl;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.ImportSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.util.InvalidXMLException;
import org.eclipse.swt.widgets.Composite;

public class ImportResBindSection
extends ImportSection {
    public ImportResBindSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Imports for External Resources and Bindings", "The following definitions are included:");
    }

    @Override
    protected boolean isAppropriate() {
        return true;
    }

    @Override
    protected String getDescriptionFromImport(String source) {
        return "";
    }

    @Override
    protected Import[] getModelImportArray() {
        return this.getResourceManagerConfiguration().getImports();
    }

    @Override
    protected void setModelImportArray(Import[] imports) {
        this.getResourceManagerConfiguration().setImports(imports);
    }

    @Override
    protected void clearModelBaseValue() {
        this.getResourceManagerConfiguration().setExternalResourceBindings(externalResourceBinding0);
        this.getResourceManagerConfiguration().setExternalResources(externalResourceDescription0);
    }

    @Override
    protected boolean isValidImport(String title, String message) {
        ResourceManagerConfiguration savedRmc = this.editor.getResolvedExternalResourcesAndBindings();
        if (null != savedRmc) {
            savedRmc = (ResourceManagerConfiguration)((ResourceManagerConfiguration_impl)savedRmc).clone();
        }
        try {
            this.editor.setResolvedExternalResourcesAndBindings();
        }
        catch (InvalidXMLException e) {
            Utility.popMessage(title, message + this.editor.getMessagesToRootCause(e), 1);
            this.revert(savedRmc);
            return false;
        }
        if (!this.isValidAe()) {
            this.revert(savedRmc);
            return false;
        }
        return true;
    }

    private void revert(ResourceManagerConfiguration rmc) {
        this.getResourceManagerConfiguration().setExternalResourceBindings(rmc.getExternalResourceBindings());
        this.getResourceManagerConfiguration().setExternalResources(rmc.getExternalResources());
        this.editor.setResolvedExternalResourcesAndBindings(rmc);
    }

    @Override
    protected void finishImportChangeAction() {
        this.editor.getResourcesPage().getResourceDependencySection().refresh();
    }

    @Override
    public void enable() {
        super.enable();
        this.addButton.setEnabled(true);
    }
}

