/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.nature;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.uima.pear.PearException;
import org.apache.uima.pear.insd.edit.PearInstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectCustomizer {
    public static final String UIMA_NATURE_ID = "org.apache.uima.pear.UimaNature";

    public static void customizeProject(IContainer container, InstallationDescriptor insd) throws PearException {
        ProjectCustomizer.createPearFolderStructure(container);
        PearInstallationDescriptor.createInstallationDescriptor(container, insd, false);
        if (container.getType() == 4) {
            ProjectCustomizer.addUIMANature((IProject)container);
        }
    }

    public static void customizeProject(IProject project) throws PearException {
        InstallationDescriptor insd = new InstallationDescriptor();
        ProjectCustomizer.customizeProject((IContainer)project, insd);
    }

    public static void addUIMANature(IProject project) throws PearException {
        try {
            if (!project.hasNature(UIMA_NATURE_ID)) {
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = UIMA_NATURE_ID;
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                project.close(null);
                project.open(null);
            }
        }
        catch (Throwable e) {
            PearException subEx = new PearException("The UIMA Nature could not be added properly.", e);
            throw subEx;
        }
    }

    public static void createPearFolderStructure(IContainer container) throws PearException {
        try {
            ProjectCustomizer.createFolder(container, "metadata");
            if (container.getType() == 4) {
                ProjectCustomizer.createFolder(container, "src");
                ProjectCustomizer.createFolder(container, "bin");
                ProjectCustomizer.createFolder(container, "desc");
                ProjectCustomizer.createFolder(container, "lib");
                ProjectCustomizer.createFolder(container, "data");
                ProjectCustomizer.createFolder(container, "doc");
                ProjectCustomizer.createFolder(container, "conf");
                ProjectCustomizer.createFolder(container, "resources");
            }
        }
        catch (Throwable e) {
            PearException subEx = new PearException("The PEAR folder structure could not be created properly.", e);
            throw subEx;
        }
    }

    public static IFolder createFolder(IContainer container, String folderName) throws PearException {
        try {
            IFolder folder = container.getFolder((IPath)new Path(folderName));
            if (!folder.exists()) {
                folder.create(true, true, null);
                return folder;
            }
            return folder;
        }
        catch (Throwable e) {
            PearException subEx = new PearException("folderName could not be created properly.", e);
            throw subEx;
        }
    }

    public static IFile createFile(IProject project, String fileName, String s, boolean overrideContentIfExist) throws PearException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(s.getBytes("UTF-8"));
            return ProjectCustomizer.createFile((IContainer)project, fileName, is, overrideContentIfExist);
        }
        catch (Throwable e) {
            PearException subEx = new PearException(fileName + " could not be created/saved properly.", e);
            throw subEx;
        }
    }

    public static IFile createFile(IContainer container, String fileName, InputStream is, boolean overrideContentIfExist) throws PearException {
        try {
            ProjectCustomizer.createPearFolderStructure(container);
            if (container.exists()) {
                IFile newFile = container.getFile((IPath)new Path(fileName));
                if (!newFile.exists()) {
                    newFile.create(is, false, null);
                    return newFile;
                }
                if (overrideContentIfExist) {
                    newFile.setContents(is, true, true, null);
                }
                return newFile;
            }
            return null;
        }
        catch (Throwable e) {
            PearException subEx = new PearException(fileName + " could not be created/saved properly.", e);
            throw subEx;
        }
    }
}

