/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.caseditor.view.tree.AbstractTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.FSTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.IRootTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TreeComparator;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeOrderedRootTreeNode
extends AbstractTreeNode
implements IRootTreeNode {
    private Map<Type, TypeTreeNode> typeMap = new HashMap<Type, TypeTreeNode>();

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Type getType() {
        return null;
    }

    @Override
    public void insertFS(FeatureStructure fs, boolean withParents) {
        Type type = fs.getType();
        if (type.getShortName().equals("DebugBlockApply") || type.getShortName().equals("DebugMatchedRuleMatch") || type.getShortName().equals("DebugFailedRuleMatch") || type.getShortName().equals("DebugScriptApply") || type.getShortName().equals("DebugRuleElementMatches") || type.getShortName().equals("DebugRuleElementMatch")) {
            return;
        }
        this.insertFS(fs, type, withParents);
    }

    private void insertFS(FeatureStructure fs, Type type, boolean withParents) {
        Type parent;
        TypeTreeNode typeTreeNode = this.typeMap.get(type);
        if (typeTreeNode == null) {
            typeTreeNode = new TypeTreeNode(this, type);
            this.typeMap.put(type, typeTreeNode);
            this.addChild(typeTreeNode);
        }
        FSTreeNode node = this.createFSNode(typeTreeNode, fs);
        typeTreeNode.addChild(node);
        if (withParents && (parent = fs.getCAS().getTypeSystem().getParent(type)) != null) {
            this.insertFS(fs, parent, withParents);
        }
    }

    private FSTreeNode createFSNode(ITreeNode parent, FeatureStructure fs) {
        if (fs instanceof AnnotationFS) {
            return new AnnotationTreeNode(parent, (AnnotationFS)fs, new ArrayList<Type>());
        }
        return new FSTreeNode(parent, fs);
    }

    @Override
    public LinkedList<ITreeNode> getNodes() {
        LinkedList<ITreeNode> list = new LinkedList<ITreeNode>();
        this.getNodes(list);
        return list;
    }

    @Override
    public LinkedList<ITreeNode> getNodes(Type type) {
        Iterator<ITreeNode> iter = this.getChildrenIterator();
        LinkedList<ITreeNode> list = new LinkedList<ITreeNode>();
        while (iter.hasNext()) {
            TypeTreeNode typeNode = (TypeTreeNode)iter.next();
            if (!typeNode.getType().equals(type)) continue;
            Iterator<ITreeNode> children = typeNode.getChildrenIterator();
            list.add(typeNode);
            while (children.hasNext()) {
                list.add(children.next());
            }
        }
        return list;
    }

    @Override
    public LinkedList<ITreeNode> getNodes(AnnotationFS annot) {
        Iterator<ITreeNode> iter = this.getChildrenIterator();
        LinkedList<ITreeNode> list = new LinkedList<ITreeNode>();
        while (iter.hasNext()) {
            TypeTreeNode typeNode = (TypeTreeNode)iter.next();
            if (!typeNode.getType().equals(annot.getType())) continue;
            Iterator<ITreeNode> children = typeNode.getChildrenIterator();
            while (children.hasNext()) {
                AnnotationTreeNode node = (AnnotationTreeNode)children.next();
                if (!node.getAnnotation().equals(annot)) continue;
                list.add(node);
                return list;
            }
        }
        return list;
    }

    @Override
    public void sort() {
        this.sort(new TreeComparator());
    }

    public Object getAdapter(Class adapter) {
        if (TypeTreeNode.class.equals((Object)adapter)) {
            return this;
        }
        if (Type.class.equals((Object)adapter)) {
            return null;
        }
        return null;
    }
}

