/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.ErrorManager;

public abstract class Message {
    public StringTemplate msgST;
    public StringTemplate locationST;
    public StringTemplate reportST;
    public StringTemplate messageFormatST;
    public int msgID;
    public Object arg;
    public Object arg2;
    public Throwable e;
    public String file;
    public int line = -1;
    public int column = -1;

    public Message() {
    }

    public Message(int msgID) {
        this(msgID, null, null);
    }

    public Message(int msgID, Object arg, Object arg2) {
        this.setMessageID(msgID);
        this.arg = arg;
        this.arg2 = arg2;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setMessageID(int msgID) {
        this.msgID = msgID;
        this.msgST = ErrorManager.getMessage(msgID);
    }

    public StringTemplate getMessageTemplate() {
        return this.msgST.getInstanceOf();
    }

    public StringTemplate getLocationTemplate() {
        return this.locationST.getInstanceOf();
    }

    public String toString(StringTemplate messageST) {
        this.locationST = ErrorManager.getLocationFormat();
        this.reportST = ErrorManager.getReportFormat();
        this.messageFormatST = ErrorManager.getMessageFormat();
        boolean locationValid = false;
        if (this.line != -1) {
            this.locationST.setAttribute("line", this.line);
            locationValid = true;
        }
        if (this.column != -1) {
            this.locationST.setAttribute("column", this.column);
            locationValid = true;
        }
        if (this.file != null) {
            this.locationST.setAttribute("file", this.file);
            locationValid = true;
        }
        this.messageFormatST.setAttribute("id", this.msgID);
        this.messageFormatST.setAttribute("text", messageST);
        if (locationValid) {
            this.reportST.setAttribute("location", this.locationST);
        }
        this.reportST.setAttribute("message", this.messageFormatST);
        this.reportST.setAttribute("type", ErrorManager.getMessageType(this.msgID));
        return this.reportST.toString();
    }
}

