/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class DynamicAnchoringAction
extends AbstractRutaAction {
    private final BooleanExpression active;
    private final NumberExpression panelty;
    private final NumberExpression factor;

    public DynamicAnchoringAction(BooleanExpression active, NumberExpression panelty, NumberExpression factor) {
        this.active = active;
        this.panelty = panelty;
        this.factor = factor;
    }

    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        RutaBlock parent = element.getParent();
        boolean activated = this.active.getBooleanValue(parent);
        stream.setDynamicAnchoring(activated);
        if (this.panelty != null) {
            double p = this.panelty.getDoubleValue(parent);
            stream.setIndexPenalty(p);
        }
        if (this.factor != null) {
            double f = this.factor.getDoubleValue(parent);
            stream.setAnchoringFactor(f);
        }
    }

    public BooleanExpression getActive() {
        return this.active;
    }

    public NumberExpression getPanelty() {
        return this.panelty;
    }

    public NumberExpression getFactor() {
        return this.factor;
    }
}

