/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class GetFeatureAction
extends AbstractRutaAction {
    private StringExpression featureStringExpression;
    private String variable;

    public GetFeatureAction(StringExpression f, String variable) {
        this.featureStringExpression = f;
        this.variable = variable;
    }

    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<Object> types = new ArrayList();
        if (element instanceof RutaRuleElement) {
            types = ((RutaRuleElement)element).getMatcher().getTypes(element.getParent(), stream);
        }
        if (types == null) {
            return;
        }
        for (Type type : types) {
            String stringValue = this.featureStringExpression.getStringValue(element.getParent());
            Feature featureByBaseName = type.getFeatureByBaseName(stringValue);
            RutaEnvironment environment = element.getParent().getEnvironment();
            List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotationsOf(element, stream);
            for (AnnotationFS annotationFS : matchedAnnotations) {
                Object value;
                if (annotationFS.getType().getFeatureByBaseName(stringValue) == null) {
                    System.out.println("Can't access feature " + stringValue + ", because it's not defined in the matched type: " + annotationFS.getType());
                    return;
                }
                String featName = featureByBaseName.getRange().getName();
                if (environment.getVariableType(this.variable).equals(String.class) && featName.equals("uima.cas.String")) {
                    value = annotationFS.getStringValue(featureByBaseName);
                    environment.setVariableValue(this.variable, value);
                    continue;
                }
                if (Number.class.isAssignableFrom(environment.getVariableType(this.variable))) {
                    value = 0;
                    if (featName.equals("uima.cas.Integer")) {
                        value = annotationFS.getIntValue(featureByBaseName);
                    } else if (featName.equals("uima.cas.Double")) {
                        value = annotationFS.getDoubleValue(featureByBaseName);
                    } else if (featName.equals("uima.cas.Float")) {
                        value = Float.valueOf(annotationFS.getFloatValue(featureByBaseName));
                    } else if (featName.equals("uima.cas.Byte")) {
                        value = annotationFS.getByteValue(featureByBaseName);
                    } else if (featName.equals("uima.cas.Short")) {
                        value = annotationFS.getShortValue(featureByBaseName);
                    } else if (featName.equals("uima.cas.Long")) {
                        value = annotationFS.getLongValue(featureByBaseName);
                    }
                    environment.setVariableValue(this.variable, value);
                    continue;
                }
                if (environment.getVariableType(this.variable).equals(Boolean.class) && featName.equals("uima.cas.Boolean")) {
                    value = annotationFS.getBooleanValue(featureByBaseName);
                    environment.setVariableValue(this.variable, value);
                    continue;
                }
                if (!environment.getVariableType(this.variable).equals(Type.class) || !featName.equals("uima.cas.String")) continue;
                value = annotationFS.getStringValue(featureByBaseName);
                Type t = stream.getCas().getTypeSystem().getType((String)value);
                if (t == null) continue;
                environment.setVariableValue(this.variable, t);
            }
        }
    }

    public StringExpression getFeatureStringExpression() {
        return this.featureStringExpression;
    }

    public String getVariable() {
        return this.variable;
    }
}

