/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchedTextAction
extends AbstractRutaAction {
    private final String var;
    private final List<NumberExpression> list;

    public MatchedTextAction(String var, List<NumberExpression> list) {
        this.var = var;
        this.list = list;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<Integer> indexList = this.getIndexList(match, element);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(stream, indexList, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            element.getParent().getEnvironment().setVariableValue(this.var, matchedAnnotation.getCoveredText());
        }
    }

    public String getVar() {
        return this.var;
    }

    public List<NumberExpression> getList() {
        return this.list;
    }

    protected List<Integer> getIndexList(RuleMatch match, RuleElement element) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (this.list == null || this.list.isEmpty()) {
            int self = element.getContainer().getRuleElements().indexOf(element) + 1;
            indexList.add(self);
            return indexList;
        }
        int last = 0x7FFFFFFE;
        for (NumberExpression each : this.list) {
            int value = each.getIntegerValue(element.getParent());
            for (int i = Math.min(value, last + 1); i < value; ++i) {
                indexList.add(i);
            }
            indexList.add(value);
        }
        return indexList;
    }
}

