/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.List;
import org.antlr.runtime.Token;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.condition.AfterCondition;
import org.apache.uima.ruta.condition.AndCondition;
import org.apache.uima.ruta.condition.BeforeCondition;
import org.apache.uima.ruta.condition.ContainsCondition;
import org.apache.uima.ruta.condition.ContextCountCondition;
import org.apache.uima.ruta.condition.CountCondition;
import org.apache.uima.ruta.condition.CurrentCountCondition;
import org.apache.uima.ruta.condition.EndsWithCondition;
import org.apache.uima.ruta.condition.FeatureCondition;
import org.apache.uima.ruta.condition.IfCondition;
import org.apache.uima.ruta.condition.InListCondition;
import org.apache.uima.ruta.condition.IsCondition;
import org.apache.uima.ruta.condition.LastCondition;
import org.apache.uima.ruta.condition.MOfNCondition;
import org.apache.uima.ruta.condition.NearCondition;
import org.apache.uima.ruta.condition.NotCondition;
import org.apache.uima.ruta.condition.OrCondition;
import org.apache.uima.ruta.condition.ParseCondition;
import org.apache.uima.ruta.condition.PartOfCondition;
import org.apache.uima.ruta.condition.PartOfNeqCondition;
import org.apache.uima.ruta.condition.PositionCondition;
import org.apache.uima.ruta.condition.RegExpCondition;
import org.apache.uima.ruta.condition.ScoreCondition;
import org.apache.uima.ruta.condition.SizeCondition;
import org.apache.uima.ruta.condition.StartsWithCondition;
import org.apache.uima.ruta.condition.TotalCountCondition;
import org.apache.uima.ruta.condition.VariableCondition;
import org.apache.uima.ruta.condition.VoteCondition;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.list.StringListExpression;
import org.apache.uima.ruta.expression.list.TypeListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionFactory {
    private ConditionFactory() {
    }

    public static AbstractRutaCondition createConditionAnd(List<AbstractRutaCondition> conds, RutaBlock parent) {
        return new AndCondition(conds);
    }

    public static AbstractRutaCondition createConditionOr(List<AbstractRutaCondition> conds, RutaBlock parent) {
        return new OrCondition(conds);
    }

    public static AbstractRutaCondition createConditionNot(AbstractRutaCondition cond, RutaBlock parent) {
        return new NotCondition(cond);
    }

    public static AbstractRutaCondition createConditionContains(TypeExpression typeExpr, NumberExpression min, NumberExpression max, BooleanExpression percent, RutaBlock parent) {
        return new ContainsCondition(typeExpr, min, max, percent);
    }

    public static AbstractRutaCondition createConditionContextCount(TypeExpression typeExpr, NumberExpression min, NumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new ContextCountCondition(typeExpr, min, max, varString);
    }

    public static AbstractRutaCondition createConditionCurrentCount(TypeExpression typeExpr, NumberExpression min, NumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new CurrentCountCondition(typeExpr, min, max, varString);
    }

    public static AbstractRutaCondition createConditionCount(TypeExpression typeExpr, NumberExpression min, NumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new CountCondition(typeExpr, min, max, varString);
    }

    public static AbstractRutaCondition createConditionTotalCount(TypeExpression typeExpr, NumberExpression min, NumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new TotalCountCondition(typeExpr, min, max, varString);
    }

    public static AbstractRutaCondition createConditionInList(WordListExpression listExpr, NumberExpression dist, BooleanExpression rel, RutaBlock parent) {
        return new InListCondition(listExpr, dist, rel);
    }

    public static AbstractRutaCondition createConditionMOfN(List<AbstractRutaCondition> conds, NumberExpression min, NumberExpression max, RutaBlock parent) {
        return new MOfNCondition(conds, min, max);
    }

    public static AbstractRutaCondition createConditionNear(TypeExpression typeExpr, NumberExpression min, NumberExpression max, BooleanExpression direction, BooleanExpression filtered, RutaBlock parent) {
        return new NearCondition(typeExpr, min, max, direction, filtered);
    }

    public static AbstractRutaCondition createConditionPartOf(TypeExpression type, TypeListExpression list, RutaBlock parent) {
        if (type != null) {
            return new PartOfCondition(type);
        }
        return new PartOfCondition(list);
    }

    public static AbstractRutaCondition createConditionPosition(TypeExpression typeExpr, NumberExpression pos, BooleanExpression rel, RutaBlock parent) {
        return new PositionCondition(typeExpr, pos, rel);
    }

    public static AbstractRutaCondition createConditionRegExp(StringExpression patternExpr, BooleanExpression ignoreCase, RutaBlock parent) {
        return new RegExpCondition(patternExpr, ignoreCase);
    }

    public static AbstractRutaCondition createConditionRegExp(Token var, StringExpression patternExpr, BooleanExpression ignoreCase, RutaBlock parent) {
        return new RegExpCondition(var == null ? null : var.getText(), patternExpr, ignoreCase);
    }

    public static AbstractRutaCondition createConditionScore(NumberExpression min, NumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new ScoreCondition(min, max, varString);
    }

    public static AbstractRutaCondition createConditionVote(TypeExpression type1Expr, TypeExpression type2Expr, RutaBlock parent) {
        return new VoteCondition(type1Expr, type2Expr);
    }

    public static AbstractRutaCondition createConditionLast(TypeExpression typeExpr, RutaBlock parent) {
        return new LastCondition(typeExpr);
    }

    public static AbstractRutaCondition createConditionIf(BooleanExpression e, RutaBlock parent) {
        return new IfCondition(e);
    }

    public static AbstractRutaCondition createConditionFeature(StringExpression se, Object v, RutaBlock parent) {
        if (v instanceof NumberExpression) {
            return new FeatureCondition(se, (NumberExpression)v);
        }
        if (v instanceof BooleanExpression) {
            return new FeatureCondition(se, (BooleanExpression)v);
        }
        if (v instanceof StringExpression) {
            return new FeatureCondition(se, (StringExpression)v);
        }
        return null;
    }

    public static AbstractRutaCondition createConditionParse(Token id, RutaBlock env) {
        String var = id == null ? "" : id.getText();
        return new ParseCondition(var);
    }

    public static AbstractRutaCondition createConditionVariable(Token id) {
        return new VariableCondition(id.getText());
    }

    public static AbstractRutaCondition createConditionIs(TypeExpression type, TypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new IsCondition(type);
        }
        return new IsCondition(list);
    }

    public static AbstractRutaCondition createConditionAfter(TypeExpression type, TypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new AfterCondition(type);
        }
        return new AfterCondition(list);
    }

    public static AbstractRutaCondition createConditionBefore(TypeExpression type, TypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new BeforeCondition(type);
        }
        return new BeforeCondition(list);
    }

    public static AbstractRutaCondition createConditionEndsWith(TypeExpression type, TypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new EndsWithCondition(type);
        }
        return new EndsWithCondition(list);
    }

    public static AbstractRutaCondition createConditionStartsWith(TypeExpression type, TypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new StartsWithCondition(type);
        }
        return new StartsWithCondition(list);
    }

    public static AbstractRutaCondition createConditionPartOfNeq(TypeExpression type, TypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new PartOfNeqCondition(type);
        }
        return new PartOfNeqCondition(list);
    }

    public static AbstractRutaCondition createConditionSize(ListExpression<?> list, NumberExpression min, NumberExpression max, Token var, RutaBlock env) {
        return new SizeCondition(list, min, max, var == null ? null : var.getText());
    }

    public static AbstractRutaCondition createConditionInList(StringListExpression list, NumberExpression dist, BooleanExpression rel, RutaBlock env) {
        return new InListCondition(list, dist, rel);
    }

    public static AbstractRutaCondition createConditionCount(ListExpression<Object> type, RutaExpression a, NumberExpression min, NumberExpression max, Token var, RutaBlock env) {
        return new CountCondition(type, a, min, max, var == null ? null : var.getText());
    }

    public static AbstractRutaCondition createConditionContains(ListExpression list, RutaExpression a, NumberExpression min, NumberExpression max, BooleanExpression percent, RutaBlock env) {
        return new ContainsCondition(list, a, min, max, percent);
    }
}

