/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;

public class BooleanNumberExpression
extends BooleanExpression {
    private final NumberExpression e1;
    private final String op;
    private final NumberExpression e2;

    public BooleanNumberExpression(NumberExpression e1, String op, NumberExpression e2) {
        this.e1 = e1;
        this.op = op;
        this.e2 = e2;
    }

    public boolean getBooleanValue(RutaStatement parent) {
        double doubleValue1 = this.getFristExpression().getDoubleValue(parent);
        double doubleValue2 = this.getSecondExpression().getDoubleValue(parent);
        return this.eval(doubleValue1, this.getOperator(), doubleValue2);
    }

    private boolean eval(double t1, String op, double t2) {
        if ("==".equals(op)) {
            return t1 == t2;
        }
        if ("!=".equals(op)) {
            return t1 != t2;
        }
        if ("<".equals(op)) {
            return t1 < t2;
        }
        if ("<=".equals(op)) {
            return t1 <= t2;
        }
        if (">".equals(op)) {
            return t1 > t2;
        }
        if (">=".equals(op)) {
            return t1 >= t2;
        }
        return false;
    }

    public NumberExpression getFristExpression() {
        return this.e1;
    }

    public String getOperator() {
        return this.op;
    }

    public NumberExpression getSecondExpression() {
        return this.e2;
    }

    public String getStringValue(RutaStatement parent) {
        return this.e1.getStringValue(parent) + " " + this.op + " " + this.e2.getStringValue(parent);
    }
}

