/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import org.apache.uima.cas.Type;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;

public class BooleanTypeExpression
extends BooleanExpression {
    private final TypeExpression e1;
    private final String op;
    private final TypeExpression e2;

    public BooleanTypeExpression(TypeExpression e1, String op, TypeExpression e2) {
        this.e1 = e1;
        this.op = op;
        this.e2 = e2;
    }

    public boolean getBooleanValue(RutaStatement parent) {
        Type type1 = this.getFristExpression().getType(parent);
        String first = type1.getName();
        Type type2 = this.getSecondExpression().getType(parent);
        String second = type2.getName();
        return this.eval(first, this.getOperator(), second);
    }

    private boolean eval(String t1, String op, String t2) {
        if ("==".equals(op)) {
            return t1.equals(t2);
        }
        if ("!=".equals(op)) {
            return !t1.equals(t2);
        }
        return false;
    }

    public TypeExpression getFristExpression() {
        return this.e1;
    }

    public String getOperator() {
        return this.op;
    }

    public TypeExpression getSecondExpression() {
        return this.e2;
    }

    public String getStringValue(RutaStatement parent) {
        return this.e1.getStringValue(parent) + " " + this.op + " " + this.e2.getStringValue(parent);
    }
}

