/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTextNode {
    private char value;
    private Map<Character, MultiTextNode> children;
    private Set<String> types;
    private static final int DEFAUL_INITIAL_CAPACITY = 5;

    public MultiTextNode() {
        this(' ', false);
    }

    public MultiTextNode(char value, boolean isWordEnd) {
        this(value, isWordEnd, new String[0]);
    }

    public MultiTextNode(char value, boolean isWordEnd, String ... documents) {
        this(value, isWordEnd, 5, documents);
    }

    private MultiTextNode(char value, boolean isWordEnd, int capacity, String ... documents) {
        this.value = value;
        this.children = new HashMap<Character, MultiTextNode>(capacity);
        this.setWordEnd(isWordEnd);
        for (String s : documents) {
            this.addType(s);
        }
    }

    public MultiTextNode addChild(char c, boolean isWordEnd) {
        return this.addChild(new MultiTextNode(c, false));
    }

    public MultiTextNode addChild(MultiTextNode n) {
        if (this.children == null) {
            this.children = new HashMap<Character, MultiTextNode>();
        }
        return this.children.put(Character.valueOf(n.getValue()), n);
    }

    public MultiTextNode getChildNode(char c) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(Character.valueOf(c));
    }

    public char getValue() {
        return this.value;
    }

    public void setValue(char c) {
        this.value = c;
    }

    public boolean isWordEnd() {
        return this.types != null && !this.types.isEmpty();
    }

    public Map<Character, MultiTextNode> getChildren() {
        if (this.children == null) {
            return Collections.unmodifiableMap(new HashMap());
        }
        return Collections.unmodifiableMap(this.children);
    }

    public boolean addType(String type) {
        if (this.types == null) {
            this.types = new HashSet<String>();
        }
        return this.types.add(type);
    }

    public Collection<String> getTypes() {
        if (this.types == null) {
            return Collections.unmodifiableCollection(new LinkedList());
        }
        return Collections.unmodifiableCollection(this.types);
    }

    public void setWordEnd(boolean b) {
        this.setWordEnd(b, new String[0]);
    }

    public void setWordEnd(boolean b, String ... documents) {
        for (String document : documents) {
            this.addType(document);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder(Character.toString(this.getValue()) + "\n");
        if (this.getChildren() != null) {
            LinkedList<Character> sortedList = new LinkedList<Character>();
            sortedList.addAll(this.getChildren().keySet());
            Collections.sort(sortedList);
            for (Character each : sortedList) {
                s.append(each + ", ");
            }
        }
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : ((Object)this.children).hashCode());
        result = 31 * result + (this.types == null ? 0 : ((Object)this.getTypes()).hashCode());
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTextNode other = (MultiTextNode)obj;
        if (this.children == null ? other.children != null : !((Object)this.children).equals(other.getChildren())) {
            return false;
        }
        if (this.types == null ? other.types != null : !this.typesEquals(other)) {
            return false;
        }
        return this.value == other.getValue();
    }

    private boolean typesEquals(MultiTextNode other) {
        if (this.getTypes() == null) {
            return other.getTypes() == null;
        }
        for (String s : this.getTypes()) {
            if (other.getTypes().contains(s)) continue;
            return false;
        }
        for (String s : other.getTypes()) {
            if (this.getTypes().contains(s)) continue;
            return false;
        }
        return true;
    }
}

