/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.RegExpRuleMatch;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExpRule
extends AbstractRule {
    private Map<TypeExpression, NumberExpression> typeMap;
    private StringExpression regexpExpr;

    public RegExpRule(StringExpression regexp, Map<TypeExpression, NumberExpression> typeMap, int id, RutaBlock parent) {
        super(parent, id);
        this.regexpExpr = regexp;
        this.typeMap = typeMap;
    }

    @Override
    public ScriptApply apply(RutaStream stream, InferenceCrowd crowd) {
        RuleApply ruleApply = new RuleApply(this, false);
        crowd.beginVisit(this, ruleApply);
        String regexpString = this.regexpExpr.getStringValue(this.getParent());
        AnnotationFS documentAnnotation = stream.getDocumentAnnotation();
        String document = documentAnnotation.getCoveredText();
        int delta = documentAnnotation.getBegin();
        Map<Integer, List<Type>> groupTypes = this.getGroup2Types();
        Pattern pattern = Pattern.compile(regexpString, 40);
        Matcher matcher = pattern.matcher(document);
        int groupCount = matcher.groupCount();
        while (matcher.find()) {
            RegExpRuleMatch ruleMatch = new RegExpRuleMatch(this);
            MatchResult matchResult = matcher.toMatchResult();
            for (int i = 0; i <= groupCount; ++i) {
                int begin = matchResult.start(i);
                int end = matchResult.end(i);
                List<Type> types = groupTypes.get(i);
                if (types != null) {
                    this.createAnnotations(i, delta, begin, end, types, ruleMatch, stream);
                    continue;
                }
                if (i != 0) continue;
                CAS cas = stream.getCas();
                AnnotationFS afs = cas.createAnnotation(cas.getAnnotationType(), delta + begin, delta + end);
                ruleMatch.addMatched(0, afs);
            }
            if (ruleMatch.getMatchedAnnotationsOfRoot(stream).isEmpty()) continue;
            ruleApply.add(ruleMatch);
        }
        crowd.endVisit(this, ruleApply);
        return ruleApply;
    }

    private Map<Integer, List<Type>> getGroup2Types() {
        TreeMap<Integer, List<Type>> groupTypes = new TreeMap<Integer, List<Type>>();
        Set<Map.Entry<TypeExpression, NumberExpression>> entrySet = this.typeMap.entrySet();
        for (Map.Entry<TypeExpression, NumberExpression> entry : entrySet) {
            Type type = entry.getKey().getType(this.getParent());
            NumberExpression value = entry.getValue();
            int group = value == null ? 0 : value.getIntegerValue(this.getParent());
            ArrayList<Type> list = (ArrayList<Type>)groupTypes.get(group);
            if (list == null) {
                list = new ArrayList<Type>();
                groupTypes.put(group, list);
            }
            list.add(type);
        }
        return groupTypes;
    }

    private void createAnnotations(int group, int delta, int begin, int end, List<Type> globalTypes, RegExpRuleMatch match, RutaStream stream) {
        CAS cas = stream.getCas();
        if (begin < end) {
            for (Type type : globalTypes) {
                AnnotationFS afs = cas.createAnnotation(type, delta + begin, delta + end);
                match.addMatched(group, afs);
                stream.addAnnotation(afs, true, true, match);
            }
        }
    }

    @Override
    public RutaEnvironment getEnvironment() {
        return this.getParent().getEnvironment();
    }

    public Map<TypeExpression, NumberExpression> getTypeMap() {
        return this.typeMap;
    }

    public void setTypeMap(Map<TypeExpression, NumberExpression> typeMap) {
        this.typeMap = typeMap;
    }

    public StringExpression getRegExp() {
        return this.regexpExpr;
    }

    public void setRegExp(StringExpression regexpExpr) {
        this.regexpExpr = regexpExpr;
    }
}

