/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.apache.uima.ruta.ide.parser.ast.AbstractFactory;
import org.apache.uima.ruta.ide.parser.ast.ComponentDeclaration;
import org.apache.uima.ruta.ide.parser.ast.ComponentReference;
import org.apache.uima.ruta.ide.parser.ast.RutaAbstractDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaDeclarationsStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaDeclareDeclarationsStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaFeatureDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaImportStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaImportTypesStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaPackageDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaTypeDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;

public class StatementFactory
extends AbstractFactory {
    public static RutaImportStatement createImport(ComponentDeclaration component, Token impString, int type) {
        int[] bounds = StatementFactory.getBounds(impString, (ASTNode)component);
        return new RutaImportStatement(bounds[0], bounds[1], component, type);
    }

    public static ComponentDeclaration createEmptyComponentDeclaration(Token t) {
        int[] bounds = StatementFactory.getBounds(t);
        bounds[0] = bounds[1] + 1;
        bounds[1] = bounds[0];
        return new ComponentDeclaration(bounds[0], bounds[1], "");
    }

    public static RutaImportStatement createImportTypeSystem(ComponentDeclaration dottedId, Token impString) {
        dottedId.setType(ComponentDeclaration.TYPESYSTEM);
        return StatementFactory.createImport(dottedId, impString, 3);
    }

    public static Statement createImportType(Token importToken, Token type, ComponentDeclaration ts, Token alias) {
        int[] bounds = StatementFactory.getBounds(importToken, type);
        if (ts != null) {
            bounds = StatementFactory.getBounds(importToken, (ASTNode)ts);
        }
        if (alias != null) {
            bounds = StatementFactory.getBounds(importToken, alias);
        }
        return new RutaImportTypesStatement(bounds[0], bounds[1], ts, type, null, alias);
    }

    public static Statement createImportAllPackagew(Token importToken, ComponentDeclaration ts, Token alias) {
        int[] bounds = StatementFactory.getBounds(importToken, (ASTNode)ts);
        if (alias != null) {
            bounds = StatementFactory.getBounds(importToken, alias);
        }
        return new RutaImportTypesStatement(bounds[0], bounds[1], ts, null, null, alias);
    }

    public static Statement createImportPackage(Token importToken, Token pkg, ComponentDeclaration ts, Token alias) {
        int[] bounds = StatementFactory.getBounds(importToken, pkg);
        if (ts != null) {
            bounds = StatementFactory.getBounds(importToken, (ASTNode)ts);
        }
        if (alias != null) {
            bounds = StatementFactory.getBounds(importToken, alias);
        }
        return new RutaImportTypesStatement(bounds[0], bounds[1], ts, null, pkg, alias);
    }

    public static RutaImportStatement createImportScript(ComponentDeclaration dottedId, Token impString) {
        if (dottedId != null) {
            dottedId.setType(ComponentDeclaration.SCRIPT);
        }
        return StatementFactory.createImport(dottedId, impString, 5);
    }

    public static RutaImportStatement createImportEngine(ComponentDeclaration dottedId, Token impString) {
        String text;
        dottedId.setType(ComponentDeclaration.ENGINE);
        int kind = 9;
        if (impString != null && "UIMAFIT".equals(text = impString.getText())) {
            kind = 33;
            dottedId.setType(ComponentDeclaration.UIMAFIT_ENGINE);
        }
        return StatementFactory.createImport(dottedId, impString, kind);
    }

    public static RutaPackageDeclaration createPkgDeclaration(Token dottedId, Token pString) {
        int[] bounds = StatementFactory.getBounds(pString, dottedId);
        int[] nameBounds = new int[2];
        if (dottedId != null) {
            nameBounds = StatementFactory.getBounds(dottedId);
        }
        SimpleReference ref = new SimpleReference(nameBounds[0], nameBounds[1], dottedId == null ? "" : dottedId.getText());
        return new RutaPackageDeclaration(bounds[0], bounds[1], ref);
    }

    private static RutaVariableDeclaration createVariable(Token id, Token typeToken, int type) {
        return StatementFactory.createVariable(id, typeToken, type, null);
    }

    private static RutaVariableDeclaration createVariable(Token id, Token typeToken, int type, Expression expr) {
        int[] declBounds = StatementFactory.getBounds(typeToken, id);
        int[] nameBounds = StatementFactory.getBounds(id);
        RutaVariableReference ref = new RutaVariableReference(nameBounds[0], nameBounds[1], id.getText(), type);
        return new RutaVariableDeclaration(id.getText(), nameBounds[0], nameBounds[1], declBounds[0], declBounds[1], (SimpleReference)ref, type, expr);
    }

    public static RutaVariableDeclaration createIntVariable(Token id, Token type) {
        return StatementFactory.createVariable(id, type, 786432);
    }

    public static Object createFloatVariable(Token id, Token type) {
        return StatementFactory.createVariable(id, type, 0x20040000);
    }

    public static RutaVariableDeclaration createDoubleVariable(Token id, Token type) {
        return StatementFactory.createVariable(id, type, 0x140000);
    }

    public static RutaVariableDeclaration createStringVariable(Token id, Token type) {
        return StatementFactory.createVariable(id, type, 0x200000);
    }

    public static RutaVariableDeclaration createBooleanVariable(Token id, Token type) {
        return StatementFactory.createVariable(id, type, 0x400000);
    }

    public static RutaVariableDeclaration createTypeVariable(Token id, Token type) {
        return StatementFactory.createVariable(id, type, 0x800000);
    }

    public static RutaVariableDeclaration createListVariable(Token id, Token type, Expression expr) {
        return StatementFactory.createVariable(id, type, 0x10000000, expr);
    }

    public static RutaVariableDeclaration createTableVariable(Token id, Token type, Expression expr) {
        return StatementFactory.createVariable(id, type, 262145, expr);
    }

    public static Declaration createAnnotationType(Token id, Token declareToken, Expression type, List<RutaFeatureDeclaration> features) {
        int[] declBounds = StatementFactory.getBounds(declareToken, id);
        if (features != null && !features.isEmpty()) {
            declBounds = StatementFactory.getBounds(declareToken, (ASTNode)features.get(features.size() - 1));
        }
        int[] nameBounds = StatementFactory.getBounds(id);
        RutaVariableReference ref = new RutaVariableReference(nameBounds[0], nameBounds[1], id.getText(), 0x800000);
        return new RutaTypeDeclaration(id.getText(), nameBounds[0], nameBounds[1], declBounds[0], declBounds[1], (SimpleReference)ref, features);
    }

    public static Declaration createAnnotationType(Token id, Token declareToken) {
        int[] declBounds = StatementFactory.getBounds(declareToken, id);
        int[] nameBounds = StatementFactory.getBounds(id);
        RutaVariableReference ref = new RutaVariableReference(nameBounds[0], nameBounds[1], id.getText(), 0x800000);
        return new RutaTypeDeclaration(id.getText(), nameBounds[0], nameBounds[1], declBounds[0], declBounds[1], (SimpleReference)ref);
    }

    public static RutaFeatureDeclaration createFeatureDeclaration(Object eachTO, Token eachName) {
        int[] declBounds = new int[]{0, 0};
        String type = "";
        if (eachTO instanceof ASTNode) {
            ASTNode node = (ASTNode)eachTO;
            type = node.toString();
            declBounds = StatementFactory.getBounds(eachName, node);
        } else if (eachTO instanceof Token) {
            Token token = (Token)eachTO;
            type = token.getText();
            declBounds = StatementFactory.getBounds(eachName, token);
        }
        int[] nameBounds = StatementFactory.getBounds(eachName);
        SimpleReference ref = new SimpleReference(nameBounds[0], nameBounds[1], eachName.getText());
        return new RutaFeatureDeclaration(eachName.getText(), type, nameBounds[0], nameBounds[1], declBounds[0], declBounds[1], ref, eachTO);
    }

    public static Statement createDeclareDeclarationsStatement(Token declareToken, List declarations, ASTNode parent) {
        return StatementFactory.createDeclareDeclarationsStatement(declareToken, declarations, parent, new ArrayList<RutaFeatureDeclaration>(0));
    }

    public static Statement createDeclareDeclarationsStatement(Token declareToken, List declarations, ASTNode parent, List<RutaFeatureDeclaration> features) {
        int end;
        List decls = declarations;
        for (RutaAbstractDeclaration d : decls) {
            if (d != null) continue;
            decls.remove((Object)d);
        }
        int[] declBounds = StatementFactory.getBounds(declareToken);
        int[] statementBounds = StatementFactory.getBounds(declareToken);
        if (parent != null) {
            statementBounds[1] = Math.max(statementBounds[1], parent.sourceEnd());
        } else {
            end = ((RutaAbstractDeclaration)((Object)decls.get(decls.size() - 1))).sourceEnd();
            statementBounds[1] = Math.max(statementBounds[1], end);
        }
        if (features != null && !features.isEmpty()) {
            end = features.get(features.size() - 1).sourceEnd();
            statementBounds[1] = Math.max(statementBounds[1], end);
        }
        return new RutaDeclareDeclarationsStatement(statementBounds[0], statementBounds[1], decls, parent, declBounds[0], declBounds[1], features);
    }

    public static Statement createDeclarationsStatement(Token declareToken, List declarations, Expression init) {
        List decls = declarations;
        for (RutaAbstractDeclaration d : decls) {
            if (d != null) continue;
            decls.remove((Object)d);
        }
        int[] declBounds = StatementFactory.getBounds(declareToken);
        int[] statementBounds = StatementFactory.getBounds(declareToken);
        if (init != null) {
            statementBounds[1] = Math.max(statementBounds[1], init.sourceEnd());
        } else {
            int end = ((RutaAbstractDeclaration)((Object)decls.get(decls.size() - 1))).sourceEnd();
            statementBounds[1] = Math.max(statementBounds[1], end);
        }
        return new RutaDeclarationsStatement(statementBounds[0], statementBounds[1], declarations, init, declBounds[0], declBounds[1]);
    }

    public static Statement createDeclarationsStatement(Token declareToken, List declarations) {
        return StatementFactory.createDeclarationsStatement(declareToken, declarations, null);
    }

    public static Statement createDeclarationsStatement(Token declareToken, RutaAbstractDeclaration declaration, Expression init) {
        ArrayList decl = new ArrayList();
        return StatementFactory.createDeclarationsStatement(declareToken, decl, init);
    }

    public static Statement createComposedVariableConditionDeclaration(Token id, List<RutaCondition> conditions) {
        return null;
    }

    public static Statement createComposedVariableActionDeclaration(Token id, List<RutaAction> actions) {
        return null;
    }

    public static Object createVarListVariable(Token id, Token token, Expression expr, int type) {
        return StatementFactory.createVariable(id, token, type, expr);
    }

    public static ComponentReference createComponentReference(CommonToken ct) {
        int[] nameBounds = StatementFactory.getBounds((Token)ct);
        return new ComponentReference(nameBounds[0], nameBounds[1], ct.getText());
    }

    public static ComponentReference createEmtpyComponentReference(Token t) {
        int[] nameBounds = StatementFactory.getBounds(t);
        nameBounds[0] = nameBounds[1];
        nameBounds[1] = nameBounds[0];
        return new ComponentReference(nameBounds[0], nameBounds[1], "");
    }

    public static ComponentDeclaration createComponentDeclaration(Token ct) {
        int[] nameBounds = StatementFactory.getBounds(ct);
        String text = ct.getText();
        return new ComponentDeclaration(nameBounds[0], nameBounds[0] + text.length(), text);
    }
}

