/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSectionParm;
import org.apache.uima.taeconfigurator.editors.ui.ParameterSection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;

public class ParameterSettingsSection
extends AbstractSectionParm {
    public ParameterSettingsSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Configuration Parameters", "This section list all configuration parameters, either as plain parameters, or as part of one or more groups.  Select one to show, or set the value in the right hand panel.");
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        this.toolkit.paintBordersFor(sectionClient);
        this.tree = this.newTree(sectionClient);
        ParameterSection ps = this.editor.getParameterPage().getParameterSection();
        if (null != ps) {
            ps.setSettings(this);
        }
        this.tree.addListener(32, (Listener)this);
    }

    public void refresh() {
        super.refresh();
        this.showOverrides = false;
        this.splitGroupNames = true;
        this.clearAndRefillTree(this.isParmGroup());
    }

    @Override
    public void handleEvent(Event event) {
        if (event.type == 32) {
            this.showDescriptionAsToolTip(event);
        } else if (event.widget == this.tree && event.type == 13) {
            this.editor.getSettingsPage().getValueSection().refresh();
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public String getSelectedParamName() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 0) {
            return null;
        }
        TreeItem item = items[0];
        if (this.isParameter(item)) {
            return this.getName(item.getText());
        }
        return null;
    }

    public String getSelectedParamGroupName() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 0) {
            return null;
        }
        TreeItem item = items[0];
        if (this.isParameter(item)) {
            TreeItem parent = item.getParentItem();
            if (null == parent) {
                throw new InternalErrorCDE("invalid state");
            }
            return this.getName(parent.getText());
        }
        return null;
    }

    public ConfigurationParameter getSelectedModelParameter() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 0) {
            return null;
        }
        TreeItem item = items[0];
        if (this.isParameter(item)) {
            String groupName;
            TreeItem group = item.getParentItem();
            ConfigurationParameterDeclarations cpds = this.getConfigurationParameterDeclarations();
            String string = groupName = null == group ? null : this.getName(group.getText());
            if (NOT_IN_ANY_GROUP.equals(groupName)) {
                return cpds.getConfigurationParameter(null, this.getName(item.getText()));
            }
            return cpds.getConfigurationParameter(groupName, this.getName(item.getText()));
        }
        return null;
    }
}

