/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import java.util.Map;

public final class InliningHelper {
    public static AstNode inlineMethod(MethodDeclaration method, Map<ParameterDefinition, ? extends AstNode> argumentMappings) {
        VerifyArgument.notNull((Object)method, (String)"method");
        VerifyArgument.notNull(argumentMappings, (String)"argumentMappings");
        DecompilerContext context = new DecompilerContext();
        MethodDefinition definition = method.getUserData(Keys.METHOD_DEFINITION);
        if (definition != null) {
            context.setCurrentType(definition.getDeclaringType());
        }
        InliningVisitor visitor = new InliningVisitor(context, argumentMappings);
        visitor.run(method);
        return visitor.getInlinedBody();
    }

    private static class InliningVisitor
    extends ContextTrackingVisitor<Void> {
        private final Map<ParameterDefinition, ? extends AstNode> _argumentMappings;
        private AstNode _result;

        public InliningVisitor(DecompilerContext context, Map<ParameterDefinition, ? extends AstNode> argumentMappings) {
            super(context);
            this._argumentMappings = (Map)VerifyArgument.notNull(argumentMappings, (String)"argumentMappings");
        }

        public final AstNode getInlinedBody() {
            return this._result;
        }

        @Override
        public void run(AstNode root) {
            Statement firstStatement;
            if (!(root instanceof MethodDeclaration)) {
                throw new IllegalArgumentException("InliningVisitor must be run against a MethodDeclaration.");
            }
            MethodDeclaration clone = (MethodDeclaration)root.clone();
            super.run(clone);
            BlockStatement body = clone.getBody();
            AstNodeCollection<Statement> statements = body.getStatements();
            if (statements.size() == 1 && ((firstStatement = statements.firstOrNullObject()) instanceof ExpressionStatement || firstStatement instanceof ReturnStatement)) {
                this._result = firstStatement.getChildByRole(Roles.EXPRESSION);
                this._result.remove();
                return;
            }
            this._result = body;
            this._result.remove();
        }

        @Override
        public Void visitIdentifierExpression(IdentifierExpression node, Void p) {
            Variable variable = node.getUserData(Keys.VARIABLE);
            if (variable != null && variable.isParameter()) {
                AstNode replacement;
                ParameterDefinition parameter = variable.getOriginalParameter();
                assert (parameter != null);
                if (this.areMethodsEquivalent((MethodReference)parameter.getMethod(), this.context.getCurrentMethod()) && (replacement = this._argumentMappings.get(parameter)) != null) {
                    node.replaceWith(replacement.clone());
                    return null;
                }
            }
            return (Void)super.visitIdentifierExpression(node, p);
        }

        private boolean areMethodsEquivalent(MethodReference m1, MethodDefinition m2) {
            if (m1 == m2) {
                return true;
            }
            if (m1 == null || m2 == null) {
                return false;
            }
            return StringUtilities.equals((String)m1.getFullName(), (String)m2.getFullName()) && StringUtilities.equals((String)m1.getErasedSignature(), (String)m2.getErasedSignature());
        }
    }
}

